/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import com.sdmetrics.A.A;
import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.ExpressionParser;
import com.sdmetrics.math.MappedCollectionsIterator;
import com.sdmetrics.model.MetaModel;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.XMITransformation;
import com.sdmetrics.model.XMITrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMITransformations {
    public static final String TL_ELEMENT = "xmitransformations";
    private HashMap<String, ArrayList<XMITransformation>> transformations = new HashMap();
    private MetaModel metaModel;

    public XMITransformations(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public DefaultHandler getSAXParserHandler() {
        return new XMITranformationsParser();
    }

    XMITransformation getTransformation(String string, Attributes attributes) throws SAXException {
        ArrayList<XMITransformation> arrayList = this.transformations.get(string);
        if (arrayList == null) {
            return null;
        }
        for (XMITransformation xMITransformation : arrayList) {
            try {
                if (!this.eval_boolean_expr(xMITransformation.getConditionExpression(), attributes)) continue;
                return xMITransformation;
            }
            catch (Exception exception) {
                throw new SAXException("Error evaluating condition for XMI transformation \"" + xMITransformation.getXMIPattern() + "\" in line " + xMITransformation.getLineNumber() + " of the XMI transformation file: " + exception.getMessage());
            }
        }
        return null;
    }

    private boolean eval_boolean_expr(ExpressionNode expressionNode, Attributes attributes) {
        if (expressionNode == null) {
            return true;
        }
        String string = expressionNode.getValue();
        if ("!".equals(string)) {
            return !this.eval_boolean_expr(expressionNode.getLeftNode(), attributes);
        }
        if ("&".equals(string)) {
            if (this.eval_boolean_expr(expressionNode.getLeftNode(), attributes)) {
                return this.eval_boolean_expr(expressionNode.getRightNode(), attributes);
            }
            return false;
        }
        if ("|".equals(string)) {
            if (!this.eval_boolean_expr(expressionNode.getLeftNode(), attributes)) {
                return this.eval_boolean_expr(expressionNode.getRightNode(), attributes);
            }
            return true;
        }
        if ("=".equals(string) || "!=".equals(string)) {
            String string2 = this.eval_expr(expressionNode.getLeftNode(), attributes);
            String string3 = this.eval_expr(expressionNode.getRightNode(), attributes);
            if ("=".equals(string)) {
                return string2.equals(string3);
            }
            return !string2.equals(string3);
        }
        throw new IllegalArgumentException("Illegal boolean operation: " + string);
    }

    private String eval_expr(ExpressionNode expressionNode, Attributes attributes) {
        if (expressionNode.isNumberConstant() || expressionNode.isStringConstant()) {
            return expressionNode.getValue();
        }
        int n2 = attributes.getIndex(expressionNode.getValue());
        if (n2 >= 0) {
            return attributes.getValue(n2);
        }
        return "";
    }

    class XMITranformationsParser
    extends A {
        private static final String ELEM_TRANSFORMATION = "xmitransformation";
        private static final String ELEM_TRIGGER = "trigger";
        private boolean globalRequireID = true;
        private ExpressionParser exprParser = new ExpressionParser();
        private XMITransformation currentTrans;

        XMITranformationsParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XMITransformations.TL_ELEMENT.equals(string3)) {
                this.checkVersion(attributes, null);
                this.globalRequireID = !"false".equals(attributes.getValue("requirexmiid"));
            } else if (ELEM_TRANSFORMATION.equals(string3)) {
                this.processTransformation(attributes);
            } else if (ELEM_TRIGGER.equals(string3)) {
                this.processTrigger(attributes);
            } else {
                this.reportError("Unexpected XML element <" + string3 + ">.");
            }
        }

        private void processTransformation(Attributes attributes) throws SAXException {
            MetaModelElement metaModelElement;
            String string;
            if (this.currentTrans != null) {
                this.reportError("XMI transformations must not be nested.");
            }
            if ((string = attributes.getValue("modelelement")) == null) {
                this.reportError("XMI transformation is missing the \"modelelement\" attribute.");
            }
            if ((metaModelElement = XMITransformations.this.metaModel.getType(string)) == null) {
                this.reportError("Unknown metamodel element type \"" + string + "\".");
            }
            boolean bl = "true".equals(attributes.getValue("recurse"));
            String string2 = attributes.getValue("requirexmiid");
            boolean bl2 = this.globalRequireID ? !"false".equals(string2) : "true".equals(string2);
            ExpressionNode expressionNode = null;
            String string3 = attributes.getValue("condition");
            if (string3 != null && (expressionNode = this.exprParser.parseExpression(string3)) == null) {
                this.reportError("Invalid condition expression \"" + string3 + "\": " + this.exprParser.getErrorInfo());
            }
            this.currentTrans = new XMITransformation(metaModelElement, attributes.getValue("xmipattern"), bl, bl2, expressionNode);
            this.currentTrans.setLineNumber(this.locator.getLineNumber());
        }

        private void processTrigger(Attributes attributes) throws SAXException {
            Object object;
            String string;
            String string2;
            if (this.currentTrans == null) {
                this.reportError("Trigger definition outside of an XMI transformation definition.");
            }
            if ((string2 = attributes.getValue("name")) == null) {
                this.reportError("Trigger is missing the \"name\" attribute.");
            }
            if ((string = attributes.getValue("type")) == null) {
                this.reportError("Trigger is missing the \"type\" attribute.");
            }
            if (XMITrigger.TriggerType.REFLIST.toString().equals(string)) {
                if (XMITransformations.this.metaModel.getType(string2) == null) {
                    this.reportError("Unknown metamodel element type \"" + string2 + "\" for reflist attribute \"attr\".");
                }
            } else {
                object = this.currentTrans.getType();
                if (!((MetaModelElement)object).hasAttribute(string2)) {
                    this.reportError("Attribute \"attr\": Unknown metamodel attribute \"" + string2 + "\" for elements of type \"" + ((MetaModelElement)object).getName() + "\".");
                }
            }
            try {
                object = new XMITrigger(string2, string, attributes.getValue("src"), attributes.getValue("attr"), attributes.getValue("linkbackattr"));
                this.currentTrans.addTrigger((XMITrigger)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.reportError(illegalArgumentException.getMessage());
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (ELEM_TRANSFORMATION.equals(string3)) {
                ArrayList<XMITransformation> arrayList = (ArrayList<XMITransformation>)XMITransformations.this.transformations.get(this.currentTrans.getXMIPattern());
                if (arrayList == null) {
                    arrayList = new ArrayList<XMITransformation>();
                    XMITransformations.this.transformations.put(this.currentTrans.getXMIPattern(), arrayList);
                }
                if (this.currentTrans.getConditionExpression() == null) {
                    arrayList.add(this.currentTrans);
                } else {
                    arrayList.add(0, this.currentTrans);
                }
                this.currentTrans = null;
            }
        }

        @Override
        public void endDocument() {
            HashSet<XMITransformation> hashSet = new HashSet<XMITransformation>();
            Iterator<XMITransformation> iterator = this.getXMITransIterator();
            while (iterator.hasNext()) {
                this.insertInheritedTransformations(iterator.next(), hashSet);
            }
        }

        private void insertInheritedTransformations(XMITransformation xMITransformation, Set<XMITransformation> set) {
            if (set.contains(xMITransformation)) {
                return;
            }
            set.add(xMITransformation);
            MetaModelElement metaModelElement = xMITransformation.getType().getParent();
            if (metaModelElement == null) {
                return;
            }
            XMITransformation xMITransformation2 = this.findXMITransformation(metaModelElement);
            if (xMITransformation2 == null) {
                return;
            }
            this.insertInheritedTransformations(xMITransformation2, set);
            ArrayList<XMITrigger> arrayList = new ArrayList<XMITrigger>();
            for (XMITrigger xMITrigger : xMITransformation2.getTriggerList()) {
                if (xMITransformation.hasTrigger(xMITrigger.name)) continue;
                arrayList.add(xMITrigger);
            }
            for (XMITrigger xMITrigger : arrayList) {
                xMITransformation.addTrigger(xMITrigger);
            }
        }

        private XMITransformation findXMITransformation(MetaModelElement metaModelElement) {
            Iterator<XMITransformation> iterator = this.getXMITransIterator();
            while (iterator.hasNext()) {
                XMITransformation xMITransformation = iterator.next();
                if (metaModelElement != xMITransformation.getType()) continue;
                return xMITransformation;
            }
            return null;
        }

        private Iterator<XMITransformation> getXMITransIterator() {
            return new MappedCollectionsIterator<XMITransformation>(XMITransformations.this.transformations);
        }
    }
}

