/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import com.sdmetrics.A.A;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.Model;
import com.sdmetrics.model.ModelElement;
import com.sdmetrics.model.XMIContextStack;
import com.sdmetrics.model.XMITransformation;
import com.sdmetrics.model.XMITransformations;
import com.sdmetrics.model.XMITrigger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMIReader
extends A {
    private Model model;
    private XMITransformations transformations;
    private int nestingLevel;
    private XMIContextStack stack;
    private int artificialIDCounter;
    private List<DeferredRelation> deferredRelationsList;
    private StringBuilder ctextBuffer = new StringBuilder();
    private HashMap<String, ModelElement> xmiIDMap;
    private HashMap<String, String> stringCache;
    private int elementsExtracted;
    private ProgressMessageHandler messageHandler;

    public XMIReader(XMITransformations xMITransformations, Model model) {
        this.model = model;
        this.transformations = xMITransformations;
    }

    public void setProgressMessageHandler(ProgressMessageHandler progressMessageHandler) {
        this.messageHandler = progressMessageHandler;
    }

    public int getNumberOfElements() {
        return this.elementsExtracted;
    }

    @Override
    public void startDocument() {
        this.stack = new XMIContextStack();
        this.deferredRelationsList = new LinkedList<DeferredRelation>();
        this.xmiIDMap = new HashMap(2048);
        this.stringCache = new HashMap(2048);
        this.elementsExtracted = 0;
        this.nestingLevel = 0;
        this.artificialIDCounter = 0;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.nestingLevel;
        if (this.stack.isAcceptingNewElements() && this.checkAndProcessNewElement(string3, attributes)) {
            return;
        }
        if (this.stack.isEmpty()) {
            return;
        }
        if (this.nestingLevel == this.stack.getNestingLevel() + 1) {
            this.processXMLFirstLevelChild(string3, attributes);
        } else if (this.nestingLevel == this.stack.getNestingLevel() + 2) {
            this.processXMLSecondLevelChild(attributes);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (this.stack.activeTriggerTypeEquals(XMITrigger.TriggerType.CTEXT)) {
            this.ctextBuffer.append(cArray, n2, n3);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        ModelElement modelElement;
        if (this.nestingLevel == this.stack.getNestingLevel() + 1) {
            if (this.stack.activeTriggerTypeEquals(XMITrigger.TriggerType.CTEXT)) {
                modelElement = this.stack.getModelElement();
                this.setModelAttributeValue(modelElement, this.stack.getActiveTrigger().name, this.ctextBuffer.toString());
                this.ctextBuffer.setLength(0);
            }
            this.stack.setActiveTrigger(null);
        }
        if (this.nestingLevel == this.stack.getNestingLevel()) {
            modelElement = this.stack.pop();
            String string4 = modelElement.getPlainAttribute("context");
            if (string4.equals(modelElement.getXMIID())) {
                string4 = "";
            }
            if (string4.length() == 0) {
                ModelElement modelElement2 = this.stack.getModelElement();
                if (modelElement2 != null) {
                    string4 = modelElement2.getXMIID();
                }
                this.setModelAttributeValue(modelElement, "context", string4);
            }
            this.addModelElement(modelElement.getXMIID(), modelElement);
        }
        --this.nestingLevel;
    }

    @Override
    public void endDocument() {
        for (DeferredRelation deferredRelation : this.deferredRelationsList) {
            ModelElement modelElement = this.xmiIDMap.get(deferredRelation.targetXMIID);
            if (modelElement == null || !modelElement.getType().hasAttribute(deferredRelation.linkBackAttr)) continue;
            this.setModelAttributeValue(modelElement, deferredRelation.linkBackAttr, deferredRelation.sourceElement.getXMIID());
        }
        this.stringCache = null;
        this.deferredRelationsList = null;
        this.processProfileExtensions();
        this.doCrossreferencing();
    }

    private boolean checkAndProcessNewElement(String string, Attributes attributes) throws SAXException {
        XMITransformation xMITransformation;
        int n2;
        XMITransformation xMITransformation2 = this.transformations.getTransformation(string, attributes);
        if (xMITransformation2 == null && (n2 = this.findAttributeIndex(attributes, "xmi:type", "xsi:type")) >= 0) {
            String string2 = attributes.getValue(n2);
            xMITransformation2 = this.transformations.getTransformation(string2, attributes);
        }
        if (xMITransformation2 == null && (xMITransformation = this.stack.getXMITransformation()) != null) {
            for (XMITrigger xMITrigger : xMITransformation.getTriggerList()) {
                if (xMITrigger.type != XMITrigger.TriggerType.XMI2ASSOC || xMITrigger.src == null || !xMITrigger.attr.equals(string)) continue;
                xMITransformation2 = this.transformations.getTransformation(xMITrigger.src, attributes);
                break;
            }
        }
        if (xMITransformation2 == null) {
            return false;
        }
        if (xMITransformation2.requiresXMIID() ? this.findAttributeIndex(attributes, "xmi.id", "xmi:id") < 0 : this.findAttributeIndex(attributes, "xmi.idref", "xmi:idref") >= 0) {
            return false;
        }
        this.processNewElement(xMITransformation2, string, attributes);
        return true;
    }

    private int findAttributeIndex(Attributes attributes, String string, String string2) {
        int n2 = attributes.getIndex(string);
        return n2 < 0 ? attributes.getIndex(string2) : n2;
    }

    private void processNewElement(XMITransformation xMITransformation, String string, Attributes attributes) {
        ModelElement modelElement = new ModelElement(xMITransformation.getType());
        this.processAttrTriggers(modelElement, xMITransformation, attributes);
        String string2 = modelElement.getPlainAttribute("id");
        if (string2.length() == 0) {
            string2 = "SDMetricsID." + this.artificialIDCounter++;
            this.setModelAttributeValue(modelElement, "id", string2);
        }
        this.processRelationTriggers(string, string2);
        this.stack.push(modelElement, xMITransformation, this.nestingLevel);
    }

    private void processAttrTriggers(ModelElement modelElement, XMITransformation xMITransformation, Attributes attributes) {
        MetaModelElement metaModelElement = xMITransformation.getType();
        for (XMITrigger xMITrigger : xMITransformation.getTriggerList()) {
            if (xMITrigger.type == XMITrigger.TriggerType.ATTRVAL || xMITrigger.type == XMITrigger.TriggerType.XMI2ASSOC) {
                String string = attributes.getValue(xMITrigger.attr);
                if (string == null) continue;
                if (metaModelElement.isSetAttribute(xMITrigger.name)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        this.setModelElementAttribute(modelElement, string2, xMITrigger);
                    }
                    continue;
                }
                this.setModelElementAttribute(modelElement, string, xMITrigger);
                continue;
            }
            if (xMITrigger.type != XMITrigger.TriggerType.CONSTANT) continue;
            this.setModelAttributeValue(modelElement, xMITrigger.name, xMITrigger.attr);
        }
    }

    private void setModelElementAttribute(ModelElement modelElement, String string, XMITrigger xMITrigger) {
        this.setModelAttributeValue(modelElement, xMITrigger.name, string);
        if (xMITrigger.linkback != null) {
            DeferredRelation deferredRelation = new DeferredRelation();
            deferredRelation.sourceElement = modelElement;
            deferredRelation.targetXMIID = string;
            deferredRelation.linkBackAttr = xMITrigger.linkback;
            this.deferredRelationsList.add(deferredRelation);
        }
    }

    private void processRelationTriggers(String string, String string2) {
        if (this.nestingLevel == this.stack.getNestingLevel() + 1 && !this.stack.isEmpty()) {
            for (XMITrigger xMITrigger : this.stack.getXMITransformation().getTriggerList()) {
                if ((xMITrigger.type != XMITrigger.TriggerType.CATTRVAL || !xMITrigger.src.equals(string)) && (xMITrigger.type != XMITrigger.TriggerType.XMI2ASSOC || !xMITrigger.attr.equals(string))) continue;
                this.setModelElementAttribute(this.stack.getModelElement(), string2, xMITrigger);
            }
        }
        if (this.nestingLevel == this.stack.getNestingLevel() + 2 && this.stack.activeTriggerTypeEquals(XMITrigger.TriggerType.GCATTRVAL) && !"context".equals(this.stack.getActiveTrigger().name)) {
            this.processGCATTRElement(string2);
        }
    }

    private void processXMLFirstLevelChild(String string, Attributes attributes) {
        for (XMITrigger xMITrigger : this.stack.getXMITransformation().getTriggerList()) {
            if (xMITrigger.type == XMITrigger.TriggerType.CATTRVAL && xMITrigger.src.equals(string) || xMITrigger.type == XMITrigger.TriggerType.XMI2ASSOC && xMITrigger.attr.equals(string)) {
                int n2 = xMITrigger.type == XMITrigger.TriggerType.XMI2ASSOC ? this.findAttributeIndex(attributes, "xmi:idref", "xmi.idref") : attributes.getIndex(xMITrigger.attr);
                if (n2 < 0) continue;
                String string2 = attributes.getValue(n2);
                this.setModelElementAttribute(this.stack.getModelElement(), string2, xMITrigger);
                continue;
            }
            if (xMITrigger.type != XMITrigger.TriggerType.GCATTRVAL && xMITrigger.type != XMITrigger.TriggerType.CTEXT && xMITrigger.type != XMITrigger.TriggerType.REFLIST || !xMITrigger.src.equals(string)) continue;
            this.stack.setActiveTrigger(xMITrigger);
        }
    }

    private void processXMLSecondLevelChild(Attributes attributes) {
        if (this.stack.activeTriggerTypeEquals(XMITrigger.TriggerType.GCATTRVAL)) {
            String string = attributes.getValue(this.stack.getActiveTrigger().attr);
            this.processGCATTRElement(string);
        } else if (this.stack.activeTriggerTypeEquals(XMITrigger.TriggerType.REFLIST)) {
            this.processReflistElement(attributes);
        }
    }

    private void processGCATTRElement(String string) {
        XMITrigger xMITrigger = this.stack.getActiveTrigger();
        MetaModelElement metaModelElement = this.stack.getModelElement().getType();
        if (metaModelElement.hasAttribute(xMITrigger.name) && string != null) {
            this.setModelElementAttribute(this.stack.getModelElement(), string, xMITrigger);
        }
        if (!metaModelElement.isSetAttribute(xMITrigger.name)) {
            this.stack.setActiveTrigger(null);
        }
    }

    private boolean processReflistElement(Attributes attributes) {
        XMITrigger xMITrigger = this.stack.getActiveTrigger();
        String string = attributes.getValue(xMITrigger.attr);
        if (string == null) {
            return false;
        }
        ModelElement modelElement = this.stack.getModelElement();
        String string2 = modelElement.getPlainAttribute("id");
        MetaModelElement metaModelElement = this.model.getMetaModel().getType(xMITrigger.name);
        ModelElement modelElement2 = new ModelElement(metaModelElement);
        this.setModelAttributeValue(modelElement2, "context", string2);
        this.setModelAttributeValue(modelElement2, xMITrigger.name, string);
        this.setModelAttributeValue(modelElement2, "name", "");
        this.setModelAttributeValue(modelElement2, "id", string2 + string);
        this.addModelElement(modelElement2.getPlainAttribute("id"), modelElement2);
        return true;
    }

    private void setModelAttributeValue(ModelElement modelElement, String string, String string2) {
        String string3 = this.stringCache.get(string2);
        if (string3 == null && string2 != null) {
            string3 = string2;
            this.stringCache.put(string2, string2);
        }
        modelElement.setAttribute(string, string3);
    }

    private void addModelElement(String string, ModelElement modelElement) {
        modelElement.setRunningID(this.elementsExtracted);
        this.xmiIDMap.put(string, modelElement);
        this.model.addElement(modelElement);
        ++this.elementsExtracted;
        if (this.messageHandler != null && this.elementsExtracted % 1000 == 0) {
            this.messageHandler.reportXMIProgress("Reading UML model. Elements processed: " + this.elementsExtracted);
        }
    }

    private void processProfileExtensions() {
        String string;
        int n2 = 0;
        LinkedList<MetaModelElement> linkedList = new LinkedList<MetaModelElement>();
        for (MetaModelElement metaModelElement : this.model.getMetaModel()) {
            string = metaModelElement.getExtensionReference();
            if (string == null) continue;
            linkedList.add(metaModelElement);
            n2 += this.model.getElements(metaModelElement).size();
        }
        if (n2 == 0) {
            return;
        }
        if (this.messageHandler != null) {
            this.messageHandler.reportXMIProgress("Processing " + n2 + " model extensions");
        }
        for (MetaModelElement metaModelElement : linkedList) {
            string = metaModelElement.getExtensionReference();
            for (ModelElement modelElement : this.model.getElements(metaModelElement)) {
                String string2 = modelElement.getPlainAttribute(string);
                ModelElement modelElement2 = this.xmiIDMap.get(string2);
                if (modelElement2 == null) continue;
                if (metaModelElement.specializes(modelElement2.getType())) {
                    modelElement.merge(modelElement2);
                    this.model.removeElement(modelElement2);
                    this.xmiIDMap.put(string2, modelElement);
                    continue;
                }
                modelElement.setAttribute("name", modelElement2.getName());
                modelElement.setAttribute("context", modelElement2.getPlainAttribute("context"));
            }
        }
    }

    private void doCrossreferencing() {
        if (this.messageHandler != null) {
            this.messageHandler.reportXMIProgress("Crossreferencing " + this.elementsExtracted + " model elements");
        }
        for (MetaModelElement metaModelElement : this.model.getMetaModel()) {
            for (String string : metaModelElement.getAttributeNames()) {
                if (!metaModelElement.isRefAttribute(string)) continue;
                boolean bl = metaModelElement.isSetAttribute(string);
                for (ModelElement modelElement : this.model.getElements(metaModelElement)) {
                    Object object;
                    if (bl) {
                        object = modelElement.getSetAttribute(string);
                        if (object.isEmpty()) continue;
                        HashSet<ModelElement> hashSet = new HashSet<ModelElement>(object.size());
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Object e2 = iterator.next();
                            ModelElement modelElement2 = this.xmiIDMap.get(e2);
                            if (modelElement2 == null) continue;
                            modelElement2.addRelation(string, modelElement);
                            hashSet.add(modelElement2);
                        }
                        modelElement.setSetAttribute(string, hashSet);
                        continue;
                    }
                    object = this.xmiIDMap.get(modelElement.getPlainAttribute(string));
                    if (object != null) {
                        ((ModelElement)object).addRelation(string, modelElement);
                    }
                    modelElement.setRefAttribute(string, (ModelElement)object);
                }
            }
        }
        this.xmiIDMap = null;
    }

    private static class DeferredRelation {
        ModelElement sourceElement;
        String targetXMIID;
        String linkBackAttr;

        private DeferredRelation() {
        }
    }

    public static interface ProgressMessageHandler {
        public void reportXMIProgress(String var1);
    }
}

