/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import com.sdmetrics.model.ModelElement;
import com.sdmetrics.model.XMITransformation;
import com.sdmetrics.model.XMITrigger;
import java.util.ArrayList;

class XMIContextStack {
    private ArrayList<Context> stack = new ArrayList();
    private int topIndex;
    private Context top = new Context();

    XMIContextStack() {
        this.stack.add(this.top);
        this.topIndex = 0;
    }

    void push(ModelElement modelElement, XMITransformation xMITransformation, int n2) {
        ++this.topIndex;
        if (this.topIndex >= this.stack.size()) {
            this.top = new Context();
            this.stack.add(this.top);
        } else {
            this.top = this.stack.get(this.topIndex);
        }
        this.top.modelElement = modelElement;
        this.top.transformation = xMITransformation;
        this.top.nestingLevel = n2;
    }

    ModelElement pop() {
        ModelElement modelElement = this.top.modelElement;
        --this.topIndex;
        this.top = this.stack.get(this.topIndex);
        return modelElement;
    }

    boolean isEmpty() {
        return this.topIndex == 0;
    }

    ModelElement getModelElement() {
        return this.top.modelElement;
    }

    int getNestingLevel() {
        return this.top.nestingLevel;
    }

    XMITransformation getXMITransformation() {
        return this.top.transformation;
    }

    boolean isAcceptingNewElements() {
        if (this.top.transformation == null) {
            return true;
        }
        return this.top.transformation.getXMIRecurse();
    }

    void setActiveTrigger(XMITrigger xMITrigger) {
        this.top.activeTrigger = xMITrigger;
    }

    XMITrigger getActiveTrigger() {
        return this.top.activeTrigger;
    }

    boolean activeTriggerTypeEquals(XMITrigger.TriggerType triggerType) {
        if (this.top.activeTrigger == null) {
            return false;
        }
        return this.top.activeTrigger.type == triggerType;
    }

    private static class Context {
        ModelElement modelElement;
        int nestingLevel;
        XMITransformation transformation;
        XMITrigger activeTrigger;

        private Context() {
        }
    }
}

