/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import com.sdmetrics.model.MetaModelElement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public class ModelElement {
    private static final int INITIAL_FEW_ELEMENTS = 0;
    private static final String QUALIFIER_SEPARATOR = ".";
    private MetaModelElement type;
    private Object[] attributeValues;
    private int runningID;
    private HashMap<String, Collection<ModelElement>> relations;
    private boolean ignoreLinks = false;

    public ModelElement(MetaModelElement metaModelElement) {
        this.type = metaModelElement;
        Collection<String> collection = metaModelElement.getAttributeNames();
        this.attributeValues = new Object[collection.size()];
        for (String string : collection) {
            if (metaModelElement.isSetAttribute(string)) continue;
            this.attributeValues[metaModelElement.getAttributeIndex((String)string)] = "";
        }
    }

    void addRelation(String string, ModelElement modelElement) {
        Collection<ModelElement> collection;
        if (this.relations == null) {
            this.relations = new HashMap(0);
        }
        if ((collection = this.relations.get(string)) == null) {
            collection = new HashSet<ModelElement>(0);
            this.relations.put(string, collection);
        }
        collection.add(modelElement);
    }

    public Collection<ModelElement> getRelations(String string) {
        if (this.relations != null) {
            return this.relations.get(string);
        }
        return null;
    }

    void setAttribute(String string, String string2) {
        int n2 = this.type.getAttributeIndex(string);
        if (this.type.isSetAttribute(string)) {
            HashSet<String> hashSet = (HashSet<String>)this.attributeValues[n2];
            if (hashSet == null) {
                this.attributeValues[n2] = hashSet = new HashSet<String>(0);
            }
            hashSet.add(string2);
        } else {
            this.attributeValues[n2] = string2;
        }
    }

    void setRefAttribute(String string, ModelElement modelElement) {
        this.attributeValues[this.type.getAttributeIndex((String)string)] = modelElement;
    }

    void setSetAttribute(String string, Collection<?> collection) {
        this.attributeValues[this.type.getAttributeIndex((String)string)] = collection;
    }

    public String getPlainAttribute(String string) {
        return (String)this.attributeValues[this.type.getAttributeIndex(string)];
    }

    public ModelElement getRefAttribute(String string) {
        ModelElement modelElement = (ModelElement)this.attributeValues[this.type.getAttributeIndex(string)];
        if (modelElement != null && modelElement.ignoreLinks) {
            return null;
        }
        return modelElement;
    }

    public Collection<?> getSetAttribute(String string) {
        Collection collection = (Collection)this.attributeValues[this.type.getAttributeIndex(string)];
        if (collection == null) {
            return Collections.EMPTY_SET;
        }
        return collection;
    }

    public boolean getLinksIgnored() {
        return this.ignoreLinks;
    }

    void setLinksIgnored(boolean bl) {
        this.ignoreLinks = bl;
    }

    public MetaModelElement getType() {
        return this.type;
    }

    void setRunningID(int n2) {
        this.runningID = n2;
    }

    public String getFullName() {
        StringBuilder stringBuilder = new StringBuilder();
        ModelElement modelElement = this;
        while (modelElement != null) {
            String string = modelElement.getPlainAttribute("name");
            stringBuilder.insert(0, string);
            if ((modelElement = modelElement.getOwner()) == null) continue;
            stringBuilder.insert(0, QUALIFIER_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public ModelElement getOwner() {
        return (ModelElement)this.attributeValues[this.type.getAttributeIndex("context")];
    }

    public Collection<ModelElement> getOwnedElements() {
        return this.getRelations("context");
    }

    public String getXMIID() {
        return (String)this.attributeValues[this.type.getAttributeIndex("id")];
    }

    public String getName() {
        return (String)this.attributeValues[this.type.getAttributeIndex("name")];
    }

    public String toString() {
        return String.valueOf(this.getXMIID());
    }

    public static Comparator<ModelElement> getComparator() {
        return new ElementOrderComparator();
    }

    void merge(ModelElement modelElement) {
        this.ignoreLinks = modelElement.ignoreLinks;
        this.runningID = modelElement.runningID;
        MetaModelElement metaModelElement = modelElement.getType();
        Collection<String> collection = metaModelElement.getAttributeNames();
        for (String string : collection) {
            if ("id".equals(string)) continue;
            int n2 = this.type.getAttributeIndex(string);
            int n3 = metaModelElement.getAttributeIndex(string);
            this.attributeValues[n2] = modelElement.attributeValues[n3];
        }
    }

    private static class ElementOrderComparator
    implements Comparator<ModelElement>,
    Serializable {
        private static final long serialVersionUID = -7690366551032834958L;

        private ElementOrderComparator() {
        }

        @Override
        public int compare(ModelElement modelElement, ModelElement modelElement2) {
            int n2;
            int n3 = modelElement.runningID;
            return n3 < (n2 = modelElement2.runningID) ? -1 : (n3 == n2 ? 0 : 1);
        }
    }
}

