/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import com.sdmetrics.math.MappedCollectionsIterator;
import com.sdmetrics.model.ElementFilters;
import com.sdmetrics.model.MetaModel;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.ModelElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Model
implements Iterable<ModelElement> {
    private MetaModel metaModel;
    private HashMap<MetaModelElement, ArrayList<ModelElement>> elementsByType;
    private HashMap<MetaModelElement, ArrayList<ModelElement>> acceptedElementsByType;

    public Model(MetaModel metaModel) {
        this.metaModel = metaModel;
        this.elementsByType = new HashMap(metaModel.getNumberOfTypes());
        for (MetaModelElement metaModelElement : metaModel) {
            this.elementsByType.put(metaModelElement, new ArrayList());
        }
    }

    public void setFilter(String[] stringArray, boolean bl, boolean bl2) {
        if (stringArray == null || stringArray.length == 0) {
            for (ModelElement modelElement : this) {
                modelElement.setLinksIgnored(false);
            }
            this.acceptedElementsByType = null;
            return;
        }
        ElementFilters elementFilters = new ElementFilters(stringArray);
        this.acceptedElementsByType = new HashMap(this.metaModel.getNumberOfTypes());
        for (MetaModelElement metaModelElement : this.metaModel) {
            ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
            this.acceptedElementsByType.put(metaModelElement, arrayList);
            for (ModelElement modelElement : this.elementsByType.get(metaModelElement)) {
                boolean bl3;
                if (elementFilters.matches(modelElement)) {
                    bl3 = bl;
                } else {
                    boolean bl4 = bl3 = !bl;
                }
                if (bl3) {
                    arrayList.add(modelElement);
                }
                modelElement.setLinksIgnored(bl2 && !bl3);
            }
        }
    }

    public List<ModelElement> getElements(MetaModelElement metaModelElement) {
        return this.elementsByType.get(metaModelElement);
    }

    public List<ModelElement> getAcceptedElements(MetaModelElement metaModelElement) {
        if (this.acceptedElementsByType == null) {
            return this.elementsByType.get(metaModelElement);
        }
        return this.acceptedElementsByType.get(metaModelElement);
    }

    @Override
    public Iterator<ModelElement> iterator() {
        return new MappedCollectionsIterator<ModelElement>(this.elementsByType);
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    void addElement(ModelElement modelElement) {
        this.elementsByType.get(modelElement.getType()).add(modelElement);
    }

    void removeElement(ModelElement modelElement) {
        this.elementsByType.get(modelElement.getType()).remove(modelElement);
    }
}

