/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MetaModelElement {
    static final String ID = "id";
    static final String NAME = "name";
    static final String CONTEXT = "context";
    private String typeName;
    private MetaModelElement parent;
    private Map<String, MetaModelElementAttribute> attributes = new LinkedHashMap<String, MetaModelElementAttribute>(4);
    private String extensionReference;

    MetaModelElement(String string, MetaModelElement metaModelElement) {
        this.typeName = string;
        if (metaModelElement != null) {
            this.parent = metaModelElement;
            for (MetaModelElementAttribute metaModelElementAttribute : metaModelElement.attributes.values()) {
                this.attributes.put(metaModelElementAttribute.attrName, metaModelElementAttribute);
            }
            this.extensionReference = metaModelElement.extensionReference;
        }
    }

    public String getName() {
        return this.typeName;
    }

    public MetaModelElement getParent() {
        return this.parent;
    }

    public boolean specializes(MetaModelElement metaModelElement) {
        for (MetaModelElement metaModelElement2 = this; metaModelElement2 != null; metaModelElement2 = metaModelElement2.getParent()) {
            if (metaModelElement2 != metaModelElement) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public boolean isRefAttribute(String string) {
        return this.getAttribute((String)string).isReference;
    }

    public String getExtensionReference() {
        return this.extensionReference;
    }

    public boolean isSetAttribute(String string) {
        return this.getAttribute((String)string).isSet;
    }

    public String getAttributeDescription(String string) {
        return this.getAttribute((String)string).description;
    }

    void addAttribute(String string, boolean bl, boolean bl2) {
        MetaModelElementAttribute metaModelElementAttribute = new MetaModelElementAttribute(string, bl, bl2, this.attributes.size());
        this.attributes.put(string, metaModelElementAttribute);
    }

    int getAttributeIndex(String string) {
        return this.getAttribute((String)string).index;
    }

    void addAttributeDescription(String string, String string2) {
        MetaModelElementAttribute metaModelElementAttribute = this.getAttribute(string);
        metaModelElementAttribute.description = metaModelElementAttribute.description + string2;
    }

    private MetaModelElementAttribute getAttribute(String string) {
        MetaModelElementAttribute metaModelElementAttribute = this.attributes.get(string);
        if (metaModelElementAttribute == null) {
            throw new IllegalArgumentException("No attribute \"" + string + "\" defined for elements of type \"" + this.typeName + "\".");
        }
        return metaModelElementAttribute;
    }

    void setExtensionReference(String string) {
        this.extensionReference = string;
    }

    static class MetaModelElementAttribute {
        String attrName;
        boolean isReference;
        boolean isSet;
        String description;
        int index;

        MetaModelElementAttribute(String string, boolean bl, boolean bl2, int n2) {
            this.attrName = string;
            this.isReference = bl;
            this.isSet = bl2;
            this.description = "";
            this.index = n2;
        }
    }
}

