/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.model;

import com.sdmetrics.A.A;
import com.sdmetrics.model.MetaModelElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaModel
implements Iterable<MetaModelElement> {
    public static final String TL_ELEMENT = "sdmetricsmetamodel";
    public static final String BASE_ELEMENT = "sdmetricsbase";
    private Map<String, MetaModelElement> elementMap = new LinkedHashMap<String, MetaModelElement>();

    @Override
    public Iterator<MetaModelElement> iterator() {
        return this.elementMap.values().iterator();
    }

    public DefaultHandler getSAXParserHandler() {
        return new MetaModelParser();
    }

    public MetaModelElement getType(String string) {
        return this.elementMap.get(string);
    }

    int getNumberOfTypes() {
        return this.elementMap.size();
    }

    private class MetaModelParser
    extends A {
        private static final String ELEM_MODELELEMENT = "modelelement";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_PARENT = "parent";
        private static final String ELEM_ATTRIBUTE = "attribute";
        private static final String ATTR_TYPE = "type";
        private static final String ATTR_MULTIPLICITY = "multiplicity";
        private MetaModelElement currentMME = null;
        private String currentAttributeName = null;

        private MetaModelParser() {
        }

        @Override
        public void startDocument() {
            MetaModel.this.elementMap.clear();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (MetaModel.TL_ELEMENT.equals(string3)) {
                this.checkVersion(attributes, null);
            } else if (ELEM_MODELELEMENT.equals(string3)) {
                this.handleMetaModelElement(attributes);
            } else if (ELEM_ATTRIBUTE.equals(string3)) {
                this.handleAttributeDefinition(attributes);
            } else {
                this.reportError("Unexpected XML element <" + string3 + ">.");
            }
        }

        private void handleMetaModelElement(Attributes attributes) throws SAXException {
            MetaModelElement metaModelElement;
            String string;
            String string2 = attributes.getValue(ATTR_NAME);
            if (string2 == null) {
                this.reportError("Model element is missing \"name\" attribute.");
            }
            if ((string = attributes.getValue(ATTR_PARENT)) == null) {
                string = MetaModel.BASE_ELEMENT;
            }
            if ((metaModelElement = (MetaModelElement)MetaModel.this.elementMap.get(string)) == null && !MetaModel.BASE_ELEMENT.equals(string2)) {
                if (MetaModel.BASE_ELEMENT.equals(string)) {
                    this.reportError("The first metamodel element to be defined must be named \"sdmetricsbase\".");
                }
                this.reportError("Unknown parent type \"" + string + "\" for model element \"" + string2 + "\".");
            }
            this.currentMME = new MetaModelElement(string2, metaModelElement);
            MetaModel.this.elementMap.put(string2, this.currentMME);
            this.currentAttributeName = null;
        }

        private void handleAttributeDefinition(Attributes attributes) throws SAXException {
            if (this.currentMME == null) {
                this.reportError("Attribute definition outside model element definition.");
            }
            this.currentAttributeName = attributes.getValue(ATTR_NAME);
            if (this.currentAttributeName == null) {
                this.reportError("Attribute without a name for model element \"" + this.currentMME.getName() + "\".");
            }
            boolean bl = "ref".equals(attributes.getValue(ATTR_TYPE));
            boolean bl2 = "many".equals(attributes.getValue(ATTR_MULTIPLICITY));
            if ("extref".equals(attributes.getValue(ATTR_TYPE))) {
                if (this.currentMME.getExtensionReference() != null) {
                    this.reportError("Duplicate extension reference attribute '" + this.currentAttributeName + "'.");
                }
                if (bl2) {
                    this.reportError("Extension reference attribute '" + this.currentAttributeName + "' cannot be multi-valued.");
                }
                bl = true;
                this.currentMME.setExtensionReference(this.currentAttributeName);
            }
            this.currentMME.addAttribute(this.currentAttributeName, bl, bl2);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (ELEM_MODELELEMENT.equals(string3)) {
                this.currentMME = null;
            } else if (ELEM_ATTRIBUTE.equals(string3)) {
                this.currentAttributeName = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) {
            if (this.currentMME != null && this.currentAttributeName != null) {
                this.currentMME.addAttributeDescription(this.currentAttributeName, new String(cArray, n2, n3));
            }
        }
    }
}

