/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.MetricTools;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;

public class SummationHelper {
    private ExpressionNode sumExpression;
    private float total = 0.0f;
    private MetricsEngine engine;
    private boolean processMin = false;
    private boolean processMax = false;
    private boolean firstCall = true;

    public SummationHelper(MetricsEngine metricsEngine, ProcedureAttributes procedureAttributes) throws SDMetricsException {
        this.engine = metricsEngine;
        this.sumExpression = procedureAttributes.getExpression("sum");
        String string = procedureAttributes.getStringValue("stat");
        if (string != null) {
            if ("min".equals(string)) {
                this.processMin = true;
            } else if ("max".equals(string)) {
                this.processMax = true;
            } else if (!"sum".equals(string)) {
                throw new SDMetricsException(null, null, "Illegal value '" + string + "' for attribute 'stat'.");
            }
        }
    }

    public void add(ModelElement modelElement, Variables variables) throws SDMetricsException {
        if (this.sumExpression == null) {
            this.total = (float)((double)this.total + 1.0);
            return;
        }
        float f2 = ((Number)this.engine.evalExpression(modelElement, this.sumExpression, variables)).floatValue();
        if (this.processMax) {
            if (this.firstCall || f2 > this.total) {
                this.total = f2;
            }
        } else if (this.processMin) {
            if (this.firstCall || f2 < this.total) {
                this.total = f2;
            }
        } else {
            this.total += f2;
        }
        this.firstCall = false;
    }

    public void add(float f2) {
        this.total += f2;
    }

    public void raiseTo(float f2) {
        if (f2 > this.total) {
            this.total = f2;
        }
    }

    public Number getTotal() {
        return MetricTools.getNumber(this.total);
    }
}

