/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.metrics.SDMetricsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class StronglyConnectedComponents<T> {
    private Graph<T> graph;
    private HashMap<T, NodeInfo> infoMap;
    private ArrayList<Collection<T>> connectedComponents;
    private LinkedList<T> stack = new LinkedList();
    private int cdfi;
    private int minCCSize = 0;
    private boolean countIsolatedIfSelfref;

    public int getConnectedComponentCount() {
        return this.connectedComponents.size();
    }

    public Collection<T> getConnectedComponent(int n2) {
        return this.connectedComponents.get(n2);
    }

    public int getIndexFor(T t2) {
        NodeInfo nodeInfo = this.infoMap.get(t2);
        return nodeInfo == null ? -1 : this.infoMap.get(t2).ccIndex;
    }

    public void calculateConnectedComponents(Graph<T> graph, int n2, boolean bl) throws SDMetricsException {
        this.graph = graph;
        this.minCCSize = n2;
        this.countIsolatedIfSelfref = bl;
        Collection<T> collection = this.graph.getNodes();
        this.infoMap = new HashMap(collection.size());
        for (Object object : collection) {
            this.infoMap.put(object, new NodeInfo());
        }
        this.connectedComponents = new ArrayList();
        this.cdfi = 0;
        this.stack.clear();
        for (Object object : collection) {
            this.searchSCC(object);
        }
        for (int i2 = 0; i2 < this.connectedComponents.size(); ++i2) {
            Object object;
            object = this.connectedComponents.get(i2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.infoMap.get(e2).ccIndex = i2;
            }
        }
    }

    private void searchSCC(T t2) throws SDMetricsException {
        NodeInfo nodeInfo = this.infoMap.get(t2);
        if (nodeInfo.dfi >= 0) {
            return;
        }
        ++this.cdfi;
        nodeInfo.dfi = this.cdfi;
        nodeInfo.cmd = this.cdfi;
        this.stack.add(t2);
        nodeInfo.stacked = true;
        boolean bl = false;
        for (T t3 : this.graph.getNeighbors(t2)) {
            NodeInfo nodeInfo2;
            if (t3 == t2) {
                bl = true;
            }
            if ((nodeInfo2 = this.infoMap.get(t3)) == null) continue;
            if (nodeInfo2.dfi < 0) {
                this.searchSCC(t3);
                nodeInfo.cmd = Math.min(nodeInfo.cmd, nodeInfo2.cmd);
                continue;
            }
            if (nodeInfo2.dfi >= nodeInfo.dfi || !nodeInfo2.stacked) continue;
            nodeInfo.cmd = Math.min(nodeInfo.cmd, nodeInfo2.dfi);
        }
        if (nodeInfo.cmd == nodeInfo.dfi) {
            boolean bl2;
            T t3;
            ArrayList arrayList = new ArrayList();
            do {
                t3 = this.stack.removeLast();
                arrayList.add(t3);
                this.infoMap.get(t3).stacked = false;
            } while (t3 != t2);
            boolean bl3 = bl2 = arrayList.size() >= this.minCCSize;
            if (this.minCCSize == 1 && arrayList.size() == 1 && this.countIsolatedIfSelfref) {
                bl2 = bl;
            }
            if (bl2) {
                this.connectedComponents.add(arrayList);
            }
        }
    }

    static class NodeInfo {
        boolean stacked = false;
        int dfi = -1;
        int cmd;
        int ccIndex = -1;

        NodeInfo() {
        }
    }

    public static interface Graph<T> {
        public Collection<T> getNodes();

        public Collection<T> getNeighbors(T var1) throws SDMetricsException;
    }
}

