/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.MetricTools;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Set;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;

public class SetSummationHelper {
    private ExpressionNode cumulativeSetExpression;
    private ExpressionNode valueSetExpression;
    private Collection resultSet;
    private boolean excludeSelf;
    private MetricsEngine engine;

    public SetSummationHelper(MetricsEngine metricsEngine, Set set, String string) throws SDMetricsException {
        this.engine = metricsEngine;
        ProcedureAttributes procedureAttributes = set.getAttributes();
        this.cumulativeSetExpression = procedureAttributes.getExpression(string);
        this.valueSetExpression = procedureAttributes.getExpression("valueset");
        this.excludeSelf = procedureAttributes.getBooleanValue("exclude_self", false);
        this.resultSet = MetricTools.createHashSet(set.isMultiSet());
    }

    public void add(ModelElement modelElement, Variables variables) throws SDMetricsException {
        if (this.valueSetExpression != null) {
            this.resultSet.add(this.engine.evalExpression(modelElement, this.valueSetExpression, variables));
        } else if (this.cumulativeSetExpression != null) {
            this.resultSet.addAll(this.engine.evalSetExpression(modelElement, this.cumulativeSetExpression, variables));
        } else {
            this.resultSet.add(modelElement);
        }
    }

    public void add(Collection<?> collection) {
        this.resultSet.addAll(collection);
    }

    public void excludeSelf(ModelElement modelElement) {
        if (this.excludeSelf) {
            MetricTools.removeAny(this.resultSet, modelElement);
        }
    }

    public Collection<?> getResultSet() {
        return this.resultSet;
    }
}

