/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.HashMultiSet;
import com.sdmetrics.metrics.FilterAttributeProcessor;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Set;
import com.sdmetrics.metrics.SetProcedure;
import com.sdmetrics.metrics.SetSummationHelper;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SetProcedureProjection
extends SetProcedure {
    private static final Collection<?> EMPTYSET = Collections.unmodifiableSet(new HashSet(1));
    private static final Collection<?> EMPTYMULTISET = Collections.unmodifiableCollection(new HashMultiSet(1));

    @Override
    public Collection<?> calculate(ModelElement modelElement, Set set) throws SDMetricsException {
        Variables variables;
        ProcedureAttributes procedureAttributes = set.getAttributes();
        Collection<ModelElement> collection = this.getRelationOrSet(modelElement, procedureAttributes, variables = new Variables(modelElement));
        if (collection == null) {
            return set.isMultiSet() ? EMPTYMULTISET : EMPTYSET;
        }
        FilterAttributeProcessor filterAttributeProcessor = this.getFilterAttributeProcessor(procedureAttributes);
        SetSummationHelper setSummationHelper = new SetSummationHelper(this.getMetricsEngine(), set, "set");
        boolean bl = procedureAttributes.getBooleanValue("recurse", false);
        for (ModelElement modelElement2 : filterAttributeProcessor.fullIteration(collection, variables)) {
            if (filterAttributeProcessor.isValid()) {
                setSummationHelper.add(modelElement2, variables);
            }
            if (!bl || !this.isCompatible(modelElement, set, modelElement2)) continue;
            setSummationHelper.add(this.getMetricsEngine().getSet(modelElement2, set));
        }
        setSummationHelper.excludeSelf(modelElement);
        Collection<?> collection2 = setSummationHelper.getResultSet();
        if (!set.isMultiSet() && ((Object)collection).equals(collection2)) {
            return collection;
        }
        return collection2;
    }
}

