/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.ExpressionParser;
import com.sdmetrics.metrics.MetricStore;
import com.sdmetrics.metrics.Rule;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.model.MetaModelElement;
import java.util.Collection;
import java.util.HashSet;

public class RuleFilter {
    private ExpressionNode filterRoot;

    public RuleFilter() {
        this.filterRoot = null;
    }

    public RuleFilter(String string) throws SDMetricsException {
        if (string != null && string.length() > 0) {
            ExpressionParser expressionParser = new ExpressionParser();
            this.filterRoot = expressionParser.parseExpression(string);
            if (this.filterRoot == null) {
                throw new SDMetricsException(null, null, "Invalid design rule filter: " + string + "\n" + expressionParser.getErrorInfo());
            }
            String string2 = this.validateFilter(this.filterRoot);
            if (string2.length() > 0) {
                throw new SDMetricsException(null, null, "Invalid design rule filter: " + string + "\n" + string2);
            }
        }
    }

    public boolean match(Rule rule) {
        return this.evalAppAreaMatch(rule.getApplicableAreas(), this.filterRoot);
    }

    private boolean evalAppAreaMatch(Collection<String> collection, ExpressionNode expressionNode) {
        if (expressionNode == null) {
            return true;
        }
        if (expressionNode.isIdentifier()) {
            if (collection == null) {
                return true;
            }
            return collection.contains(expressionNode.getValue());
        }
        if (expressionNode.isStringConstant()) {
            if (collection == null) {
                return false;
            }
            return collection.contains(expressionNode.getValue());
        }
        if ("!".equals(expressionNode.getValue())) {
            return !this.evalAppAreaMatch(collection, expressionNode.getLeftNode());
        }
        if ("&".equals(expressionNode.getValue())) {
            return this.evalAppAreaMatch(collection, expressionNode.getLeftNode()) && this.evalAppAreaMatch(collection, expressionNode.getRightNode());
        }
        return this.evalAppAreaMatch(collection, expressionNode.getLeftNode()) || this.evalAppAreaMatch(collection, expressionNode.getRightNode());
    }

    private String validateFilter(ExpressionNode expressionNode) {
        if (expressionNode == null) {
            return "";
        }
        if (expressionNode.isIdentifier() || expressionNode.isStringConstant()) {
            return "";
        }
        if (expressionNode.isOperation()) {
            if ("&".equals(expressionNode.getValue()) || "|".equals(expressionNode.getValue())) {
                return this.validateFilter(expressionNode.getLeftNode()) + this.validateFilter(expressionNode.getRightNode());
            }
            if ("!".equals(expressionNode.getValue())) {
                return this.validateFilter(expressionNode.getLeftNode());
            }
            return "Operation '" + expressionNode.getValue() + "' not allowed in filter expressions.";
        }
        return "Unexpected operand '" + expressionNode.getValue() + "'.";
    }

    public String checkIdentifiers(MetricStore metricStore) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MetaModelElement metaModelElement : metricStore.getMetaModel()) {
            for (Rule rule : metricStore.getRules(metaModelElement)) {
                if (!rule.isEnabled() || rule.getApplicableAreas() == null) continue;
                hashSet.addAll(rule.getApplicableAreas());
            }
        }
        return this.checkIdentifiers(hashSet, this.filterRoot);
    }

    private String checkIdentifiers(Collection<String> collection, ExpressionNode expressionNode) {
        if (expressionNode == null) {
            return "";
        }
        if (expressionNode.isIdentifier() || expressionNode.isStringConstant()) {
            String string = expressionNode.getValue();
            return collection.contains(string) ? "" : string;
        }
        String string = this.checkIdentifiers(collection, expressionNode.getLeftNode());
        if (string.length() == 0) {
            string = this.checkIdentifiers(collection, expressionNode.getRightNode());
        }
        return string;
    }
}

