/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.ExpressionParser;
import com.sdmetrics.metrics.MetricEntry;
import com.sdmetrics.metrics.MetricStore;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.Rule;
import com.sdmetrics.metrics.RuleProcedure;
import com.sdmetrics.metrics.RuleProcedureCache;
import com.sdmetrics.metrics.RuleViolation;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RuleEngine {
    private static final String EXEMPTIONPREFIX = "violates_";
    private MetricsEngine engine;
    private RuleProcedureCache ruleProcedures;
    private MetaModelElement exemptionType;
    private ExpressionNode exemptionExpression;
    private HashMap<Object, Object> valueCache = new HashMap();

    public RuleEngine(MetricsEngine metricsEngine) {
        this.engine = metricsEngine;
        MetricStore metricStore = metricsEngine.getMetricStore();
        this.ruleProcedures = metricStore.getRuleProcedures();
        this.exemptionType = metricStore.getRuleExemptionType();
        this.exemptionExpression = new ExpressionNode(metricStore.getRuleExemptionTag());
    }

    public MetricsEngine getMetricsEngine() {
        return this.engine;
    }

    public Collection<String> collectExemptedRules(ModelElement modelElement) throws SDMetricsException {
        Collection<ModelElement> collection = modelElement.getOwnedElements();
        if (this.exemptionType == null || collection == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>(2);
        for (ModelElement modelElement2 : collection) {
            if (modelElement2.getType() != this.exemptionType) continue;
            String string = String.valueOf(this.engine.evalExpression(modelElement2, this.exemptionExpression, null));
            int n2 = string.indexOf(EXEMPTIONPREFIX);
            while (n2 >= 0) {
                int n3;
                for (n3 = n2 += EXEMPTIONPREFIX.length(); n3 < string.length() && ExpressionParser.isIdentifierCharacter(string.charAt(n3)); ++n3) {
                }
                hashSet.add(string.substring(n2, n3));
                n2 = string.indexOf(EXEMPTIONPREFIX, n3);
            }
        }
        return hashSet;
    }

    public List<RuleViolation> checkRule(ModelElement modelElement, Rule rule) throws SDMetricsException {
        try {
            String string = rule.getProcedureName();
            RuleProcedure ruleProcedure = (RuleProcedure)this.ruleProcedures.getProcedure(string);
            ruleProcedure.setRuleEngine(this);
            ruleProcedure.checkRule(modelElement, rule);
            List<RuleViolation> list = ruleProcedure.getViolations();
            this.ruleProcedures.returnProcedure(ruleProcedure);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
        catch (SDMetricsException sDMetricsException) {
            sDMetricsException.fillInPerpetrators(modelElement, rule);
            throw sDMetricsException;
        }
        catch (RuntimeException runtimeException) {
            throw new SDMetricsException(modelElement, (MetricEntry)rule, runtimeException);
        }
    }

    Map<Object, Object> getValuesCache() {
        return this.valueCache;
    }

    public void clearValuesCache() {
        this.valueCache.clear();
    }
}

