/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.metrics.AbstractProcedure;
import com.sdmetrics.metrics.SDMetricsException;
import java.util.HashMap;
import java.util.LinkedList;

abstract class ProcedureCache<T extends AbstractProcedure> {
    private HashMap<String, ProcedureInfo> buckets = new HashMap();
    private String procedureDescription;

    ProcedureCache(String string) {
        this.procedureDescription = string;
    }

    void addProcedureClass(String string, String string2) throws SDMetricsException {
        Class<T> clazz = null;
        try {
            clazz = this.loadClass(string2);
        }
        catch (Exception exception) {
            throw new SDMetricsException(null, null, "Could not load class '" + string2 + "'. " + "\n" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + "\nMake sure the class is on the classpath, has public visibility, and extends the required base class.");
        }
        this.addProcedureClass(string, clazz);
        T t2 = this.getProcedure(string);
        this.returnProcedure(t2);
    }

    void addProcedureClass(String string, Class<? extends T> clazz) {
        ProcedureInfo procedureInfo = new ProcedureInfo();
        procedureInfo.procedureClass = clazz;
        this.buckets.put(string, procedureInfo);
    }

    boolean hasProcedure(String string) {
        return this.buckets.containsKey(string);
    }

    T getProcedure(String string) throws SDMetricsException {
        ProcedureInfo procedureInfo = this.buckets.get(string);
        if (procedureInfo == null) {
            throw new SDMetricsException(null, null, "Unknown " + this.procedureDescription + " '" + string + "'.");
        }
        if (procedureInfo.availableInstances.isEmpty()) {
            try {
                AbstractProcedure abstractProcedure = (AbstractProcedure)procedureInfo.procedureClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                abstractProcedure.setName(string);
                return (T)abstractProcedure;
            }
            catch (Exception exception) {
                throw new SDMetricsException(null, null, "Could not instantiate class '" + procedureInfo.procedureClass.getName() + "'. " + "\n" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + "\nMake sure the class has a public constructor with empty argument list and throws no exceptions.");
            }
        }
        return (T)((AbstractProcedure)procedureInfo.availableInstances.removeLast());
    }

    void returnProcedure(T t2) {
        ((AbstractProcedure)t2).clear();
        ProcedureInfo procedureInfo = this.buckets.get(((AbstractProcedure)t2).getName());
        procedureInfo.availableInstances.add(t2);
    }

    protected abstract Class<? extends T> loadClass(String var1) throws Exception;

    private class ProcedureInfo {
        Class<? extends T> procedureClass;
        LinkedList<T> availableInstances = new LinkedList();

        private ProcedureInfo() {
        }
    }
}

