/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.SDMetricsException;
import java.util.HashMap;

public class ProcedureAttributes {
    private HashMap<String, ExpressionNode> attributes = new HashMap(4);

    public ExpressionNode getExpression(String string) {
        return this.attributes.get(string);
    }

    public ExpressionNode getRequiredExpression(String string) throws SDMetricsException {
        ExpressionNode expressionNode = this.attributes.get(string);
        if (expressionNode == null) {
            throw new SDMetricsException(null, null, "Missing required attribute '" + string + "'.");
        }
        return expressionNode;
    }

    public String getStringValue(String string) throws SDMetricsException {
        ExpressionNode expressionNode = this.attributes.get(string);
        if (expressionNode == null) {
            return null;
        }
        if (expressionNode.isOperation()) {
            throw new SDMetricsException(null, null, "Attribute '" + string + "' may not contain operators.");
        }
        return expressionNode.getValue();
    }

    public String getRequiredStringValue(String string) throws SDMetricsException {
        if (!this.attributes.containsKey(string)) {
            throw new SDMetricsException(null, null, "Missing required attribute '" + string + "'.");
        }
        return this.getStringValue(string);
    }

    public boolean getBooleanValue(String string, boolean bl) throws SDMetricsException {
        String string2 = this.getStringValue(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    void setExpressionNode(String string, ExpressionNode expressionNode) {
        this.attributes.put(string, expressionNode);
    }
}

