/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.BooleanOperation;
import com.sdmetrics.metrics.Metric;
import com.sdmetrics.metrics.MetricEntry;
import com.sdmetrics.metrics.MetricProcedure;
import com.sdmetrics.metrics.MetricProcedureCache;
import com.sdmetrics.metrics.MetricStore;
import com.sdmetrics.metrics.MetricTools;
import com.sdmetrics.metrics.ProcedureCache;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.ScalarOperation;
import com.sdmetrics.metrics.Set;
import com.sdmetrics.metrics.SetOperation;
import com.sdmetrics.metrics.SetProcedure;
import com.sdmetrics.metrics.SetProcedureCache;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.MetaModel;
import com.sdmetrics.model.Model;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class MetricsEngine {
    private MetricStore metrics;
    private Model model;
    private MetricValuesCache metricCache;
    private MetricProcedureCache metricProcedures;
    private SetProcedureCache setProcedures;

    public MetricsEngine(MetricStore metricStore, Model model) {
        if (metricStore.getMetaModel() != model.getMetaModel()) {
            throw new IllegalArgumentException("Metamodel of metrics and elements do no match.");
        }
        this.metrics = metricStore;
        this.model = model;
        this.metricProcedures = metricStore.getMetricProcedures();
        this.setProcedures = metricStore.getSetProcedures();
        this.metricCache = new MetricValuesCache();
    }

    public MetaModel getMetaModel() {
        return this.metrics.getMetaModel();
    }

    public MetricStore getMetricStore() {
        return this.metrics;
    }

    public Model getModel() {
        return this.model;
    }

    public Object getMetricValue(ModelElement modelElement, Metric metric) throws SDMetricsException {
        Object object = this.metricCache.getMetricValue(modelElement, metric);
        if (object != null) {
            return object;
        }
        this.metricCache.setMetricValue(modelElement, metric, MetricTools.ZERO);
        try {
            String string = metric.getProcedureName();
            MetricProcedure metricProcedure = (MetricProcedure)this.metricProcedures.getProcedure(string);
            metricProcedure.setMetricsEngine(this);
            object = metricProcedure.calculate(modelElement, metric);
            this.metricProcedures.returnProcedure(metricProcedure);
        }
        catch (SDMetricsException sDMetricsException) {
            sDMetricsException.fillInPerpetrators(modelElement, metric);
            throw sDMetricsException;
        }
        catch (RuntimeException runtimeException) {
            throw new SDMetricsException(modelElement, (MetricEntry)metric, runtimeException);
        }
        this.metricCache.setMetricValue(modelElement, metric, object);
        return object;
    }

    public Collection<?> getSet(ModelElement modelElement, Set set) throws SDMetricsException {
        Collection<?> collection = this.metricCache.getSet(modelElement, set);
        if (collection != null) {
            return collection;
        }
        this.metricCache.setSet(modelElement, set, Collections.EMPTY_SET);
        try {
            collection = this.computeSet(modelElement, set);
        }
        catch (SDMetricsException sDMetricsException) {
            sDMetricsException.fillInPerpetrators(modelElement, set);
            throw sDMetricsException;
        }
        catch (RuntimeException runtimeException) {
            throw new SDMetricsException(modelElement, (MetricEntry)set, runtimeException);
        }
        this.metricCache.setSet(modelElement, set, collection);
        return collection;
    }

    Collection<?> computeSet(ModelElement modelElement, Set set) throws SDMetricsException {
        String string = set.getProcedureName();
        SetProcedure setProcedure = (SetProcedure)this.setProcedures.getProcedure(string);
        setProcedure.setMetricsEngine(this);
        Collection<?> collection = setProcedure.calculate(modelElement, set);
        this.setProcedures.returnProcedure(setProcedure);
        return collection;
    }

    Object evalExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        if (expressionNode.isOperation()) {
            return this.evalOperationExpression(modelElement, expressionNode, variables);
        }
        if (expressionNode.isNumberConstant()) {
            return Float.valueOf(expressionNode.getValue());
        }
        if (expressionNode.isStringConstant()) {
            return expressionNode.getValue();
        }
        if (expressionNode.isIdentifier()) {
            return this.evalIdentifier(modelElement, expressionNode.getValue(), variables);
        }
        throw new SDMetricsException(modelElement, null, "Unknown expression node type.");
    }

    ModelElement evalModelElementExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        Object object = this.evalExpression(modelElement, expressionNode, variables);
        if (!(object instanceof ModelElement)) {
            return null;
        }
        return (ModelElement)object;
    }

    boolean evalBooleanExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        String string = expressionNode.getValue();
        ProcedureCache<BooleanOperation> procedureCache = this.metrics.getExpressionOperations().getBooleanOperations();
        BooleanOperation booleanOperation = procedureCache.getProcedure(string);
        booleanOperation.setMetricsEngine(this);
        boolean bl = booleanOperation.calculateValue(modelElement, expressionNode, variables);
        procedureCache.returnProcedure(booleanOperation);
        return bl;
    }

    private Object evalOperationExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        String string = expressionNode.getValue();
        ProcedureCache<ScalarOperation> procedureCache = this.metrics.getExpressionOperations().getScalarOperations();
        ScalarOperation scalarOperation = procedureCache.getProcedure(string);
        scalarOperation.setMetricsEngine(this);
        Object object = scalarOperation.calculateValue(modelElement, expressionNode, variables);
        procedureCache.returnProcedure(scalarOperation);
        return object;
    }

    private Object evalIdentifier(ModelElement modelElement, String string, Variables variables) throws SDMetricsException {
        Metric metric = this.metrics.getMetric(modelElement.getType(), string);
        if (metric != null) {
            return this.getMetricValue(modelElement, metric);
        }
        if (modelElement.getType().hasAttribute(string) && !modelElement.getType().isSetAttribute(string)) {
            if (modelElement.getType().isRefAttribute(string)) {
                ModelElement modelElement2 = modelElement.getRefAttribute(string);
                if (modelElement2 == null) {
                    return "";
                }
                return modelElement2;
            }
            return modelElement.getPlainAttribute(string);
        }
        if ("_self".equals(string) || "self".equals(string)) {
            return modelElement;
        }
        if (variables != null && variables.hasVariable(string)) {
            return variables.getVariable(string);
        }
        throw new SDMetricsException(modelElement, null, "No metric or single-valued attribute '" + string + "' for elements of type '" + modelElement.getType().getName() + "'.");
    }

    Collection<?> evalSetExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        if (expressionNode.isIdentifier()) {
            return this.evalSetIdentifier(modelElement, expressionNode.getValue(), variables);
        }
        if (!expressionNode.isOperation()) {
            throw new SDMetricsException(modelElement, null, "Illegal set expression.");
        }
        String string = expressionNode.getValue();
        ProcedureCache<SetOperation> procedureCache = this.metrics.getExpressionOperations().getSetOperations();
        SetOperation setOperation = procedureCache.getProcedure(string);
        setOperation.setMetricsEngine(this);
        Collection<?> collection = setOperation.calculateValue(modelElement, expressionNode, variables);
        procedureCache.returnProcedure(setOperation);
        return collection;
    }

    private Collection<?> evalSetIdentifier(ModelElement modelElement, String string, Variables variables) throws SDMetricsException {
        Object object;
        Set set = this.metrics.getSet(modelElement.getType(), string);
        if (set != null) {
            return this.getSet(modelElement, set);
        }
        if (modelElement.getType().hasAttribute(string) && modelElement.getType().isSetAttribute(string)) {
            return modelElement.getSetAttribute(string);
        }
        if (variables != null && (object = variables.getVariable(string)) != null) {
            if (object instanceof Collection) {
                return (Collection)object;
            }
            throw new SDMetricsException(modelElement, null, "Variable '" + string + "' is not a set.");
        }
        throw new SDMetricsException(modelElement, null, "Unknown set identifier '" + string + "' for elements of type '" + modelElement.getType().getName() + "'.");
    }

    class MetricValuesCache {
        private HashMap<ModelElement, Object[]> metricValues = new HashMap();
        private HashMap<ModelElement, Collection<?>[]> setValues = new HashMap();

        MetricValuesCache() {
        }

        void setMetricValue(ModelElement modelElement, Metric metric, Object object) {
            Object[] objectArray = this.metricValues.get(modelElement);
            if (objectArray == null) {
                objectArray = new Object[MetricsEngine.this.metrics.getMetrics(modelElement.getType()).size()];
                this.metricValues.put(modelElement, objectArray);
            }
            objectArray[metric.getID()] = object;
        }

        void setSet(ModelElement modelElement, Set set, Collection<?> collection) {
            Collection<?>[] collectionArray = this.setValues.get(modelElement);
            if (collectionArray == null) {
                collectionArray = new Collection[MetricsEngine.this.metrics.getSets(modelElement.getType()).size()];
                this.setValues.put(modelElement, collectionArray);
            }
            collectionArray[set.getID()] = collection;
        }

        Object getMetricValue(ModelElement modelElement, Metric metric) {
            Object[] objectArray = this.metricValues.get(modelElement);
            if (objectArray != null) {
                return objectArray[metric.getID()];
            }
            return null;
        }

        Collection<?> getSet(ModelElement modelElement, Set set) {
            Collection<?>[] collectionArray = this.setValues.get(modelElement);
            if (collectionArray != null) {
                return collectionArray[set.getID()];
            }
            return null;
        }
    }
}

