/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.HashMultiSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class MetricTools {
    static final Integer ZERO = 0;
    static final Integer ONE = 1;

    public static Collection<?> createHashSet(boolean bl) {
        if (bl) {
            return new HashMultiSet(1);
        }
        return new HashSet(1);
    }

    public static Collection<?> createHashSet(boolean bl, Collection<?> collection) {
        if (bl) {
            return new HashMultiSet(collection);
        }
        return new HashSet(collection);
    }

    public static boolean isMultiSet(Collection<?> collection) {
        return collection instanceof HashMultiSet;
    }

    public static int elementCount(Collection<?> collection, Object object) {
        if (MetricTools.isMultiSet(collection)) {
            return ((HashMultiSet)collection).getElementCount(object);
        }
        if (collection.contains(object)) {
            return 1;
        }
        return 0;
    }

    public static void removeAny(Collection<?> collection, Object object) {
        if (MetricTools.isMultiSet(collection)) {
            ((HashMultiSet)collection).removeAny(object);
        } else {
            collection.remove(object);
        }
    }

    public static <T> Iterator<T> getFlatIterator(Collection<T> collection) {
        if (MetricTools.isMultiSet(collection)) {
            return ((HashMultiSet)collection).getFlatIterator();
        }
        return collection.iterator();
    }

    public static Number getNumber(float f2) {
        if (f2 > -100000.0f && f2 < 100000.0f && (double)f2 == Math.floor(f2)) {
            return (int)f2;
        }
        return Float.valueOf(f2);
    }

    public static boolean isEmptyElement(Object object) {
        return object instanceof String && "".equals(object);
    }
}

