/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.A.A;
import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.ExpressionParser;
import com.sdmetrics.metrics.ExpressionOperations;
import com.sdmetrics.metrics.Glossary;
import com.sdmetrics.metrics.Matrix;
import com.sdmetrics.metrics.Metric;
import com.sdmetrics.metrics.MetricEntry;
import com.sdmetrics.metrics.MetricProcedureCache;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.ProcedureCache;
import com.sdmetrics.metrics.Reference;
import com.sdmetrics.metrics.Rule;
import com.sdmetrics.metrics.RuleProcedureCache;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Set;
import com.sdmetrics.metrics.SetProcedureCache;
import com.sdmetrics.model.MetaModel;
import com.sdmetrics.model.MetaModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetricStore {
    public static final String TL_ELEMENT = "sdmetrics";
    private MetaModel metaModel;
    private MetricProcedureCache metricProcedures;
    private SetProcedureCache setProcedures;
    private RuleProcedureCache ruleProcedures;
    private ExpressionOperations exprOps;
    private HashMap<MetaModelElement, LinkedHashMap<String, Metric>> metrics;
    private HashMap<MetaModelElement, LinkedHashMap<String, Set>> sets;
    private HashMap<MetaModelElement, LinkedHashMap<String, Rule>> rules;
    private ArrayList<Matrix> matrices;
    private LinkedHashMap<String, Reference> references;
    private LinkedHashMap<String, Glossary> glossary;
    private HashMap<String, WordList> wordLists;
    private MetaModelElement ruleExemptionType;
    private String ruleExemptionTag;
    private boolean defaultInheritability;

    public MetricStore(MetaModel metaModel) {
        this.metaModel = metaModel;
        this.metricProcedures = new MetricProcedureCache();
        this.setProcedures = new SetProcedureCache();
        this.ruleProcedures = new RuleProcedureCache();
        this.exprOps = new ExpressionOperations();
        this.metrics = new HashMap();
        this.sets = new HashMap();
        this.rules = new HashMap();
        for (MetaModelElement metaModelElement : metaModel) {
            this.metrics.put(metaModelElement, new LinkedHashMap());
            this.sets.put(metaModelElement, new LinkedHashMap());
            this.rules.put(metaModelElement, new LinkedHashMap());
        }
        this.matrices = new ArrayList();
        this.references = new LinkedHashMap();
        this.glossary = new LinkedHashMap();
        this.wordLists = new HashMap();
    }

    public DefaultHandler getSAXParserHandler() {
        return new MetricParser();
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    MetricProcedureCache getMetricProcedures() {
        return this.metricProcedures;
    }

    SetProcedureCache getSetProcedures() {
        return this.setProcedures;
    }

    RuleProcedureCache getRuleProcedures() {
        return this.ruleProcedures;
    }

    ExpressionOperations getExpressionOperations() {
        return this.exprOps;
    }

    public Metric getMetric(MetaModelElement metaModelElement, String string) {
        return this.metrics.get(metaModelElement).get(string);
    }

    public Set getSet(MetaModelElement metaModelElement, String string) {
        return this.sets.get(metaModelElement).get(string);
    }

    public Rule getRule(MetaModelElement metaModelElement, String string) {
        return this.rules.get(metaModelElement).get(string);
    }

    public Collection<Metric> getMetrics(MetaModelElement metaModelElement) {
        return this.metrics.get(metaModelElement).values();
    }

    public Collection<Set> getSets(MetaModelElement metaModelElement) {
        return this.sets.get(metaModelElement).values();
    }

    public Collection<Rule> getRules(MetaModelElement metaModelElement) {
        return this.rules.get(metaModelElement).values();
    }

    public List<Matrix> getMatrices() {
        return this.matrices;
    }

    public Collection<Reference> getLiteratureReferences() {
        return this.references.values();
    }

    public Collection<Glossary> getGlossary() {
        return this.glossary.values();
    }

    MetaModelElement getRuleExemptionType() {
        return this.ruleExemptionType;
    }

    String getRuleExemptionTag() {
        return this.ruleExemptionTag;
    }

    boolean isWordOnList(String string, String string2) throws SDMetricsException {
        WordList wordList = this.wordLists.get(string2);
        if (wordList == null) {
            throw new SDMetricsException(null, null, string2 + ": No such word list.");
        }
        return wordList.hasWord(string);
    }

    private class MetricParser
    extends A {
        private static final String METRICPROCEDURE = "metricprocedure";
        private static final String SETPROCEDURE = "setprocedure";
        private static final String RULEPROCEDURE = "ruleprocedure";
        private static final String SCALAROPERATION = "scalaroperationdefinition";
        private static final String SETOPERATION = "setoperationdefinition";
        private static final String BOOLEANOPERATION = "booleanoperationdefinition";
        private static final String METRICENTRY = "metric";
        private static final String SETENTRY = "set";
        private static final String MATRIXENTRY = "matrix";
        private static final String RULEENTRY = "rule";
        private static final String WORDLIST = "wordlist";
        private static final String WORDLISTENTRY = "entry";
        private static final String REFERENCEENTRY = "reference";
        private static final String GLOSSARYENTRY = "term";
        private static final String DESCRIPTION = "description";
        private static final String INHERITABLE = "inheritable";
        private MetricEntry currentEntry = null;
        private String currentEntryType = null;
        private String currentEntryName = null;
        private WordList currentWordList;
        private boolean inDescription = false;
        private ExpressionParser ep = MetricStore.access$100(MetricStore.this).getExpressionParser();

        private MetricParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (MetricStore.TL_ELEMENT.equals(string3)) {
                this.checkVersion(attributes, null);
                if (attributes.getValue("ruleexemption") != null) {
                    MetricStore.this.ruleExemptionType = this.getTypeName(attributes, "ruleexemption");
                }
                MetricStore.this.ruleExemptionTag = attributes.getValue("exemptiontag");
                MetricStore.this.defaultInheritability = "true".equals(attributes.getValue(INHERITABLE));
                return;
            }
            if (DESCRIPTION.equals(string3)) {
                this.inDescription = true;
                return;
            }
            if (METRICPROCEDURE.equals(string3)) {
                this.handleProcedureDefinition(MetricStore.this.metricProcedures, string3, attributes);
            } else if (SETPROCEDURE.equals(string3)) {
                this.handleProcedureDefinition(MetricStore.this.setProcedures, string3, attributes);
            } else if (RULEPROCEDURE.equals(string3)) {
                this.handleProcedureDefinition(MetricStore.this.ruleProcedures, string3, attributes);
            } else if (SCALAROPERATION.equals(string3)) {
                String string4 = this.handleProcedureDefinition(MetricStore.this.exprOps.getScalarOperations(), string3, attributes);
                MetricStore.this.exprOps.addCustomFunctionName(string4);
            } else if (SETOPERATION.equals(string3)) {
                String string5 = this.handleProcedureDefinition(MetricStore.this.exprOps.getSetOperations(), string3, attributes);
                MetricStore.this.exprOps.addCustomFunctionName(string5);
            } else if (BOOLEANOPERATION.equals(string3)) {
                String string6 = this.handleProcedureDefinition(MetricStore.this.exprOps.getBooleanOperations(), string3, attributes);
                MetricStore.this.exprOps.addCustomFunctionName(string6);
            } else if (METRICENTRY.equals(string3)) {
                this.currentEntryType = string3;
                this.currentEntry = this.handleMetricDefinition(attributes);
            } else if (SETENTRY.equals(string3)) {
                this.currentEntryType = string3;
                this.currentEntry = this.handleSetDefinition(attributes);
            } else if (MATRIXENTRY.equals(string3)) {
                this.currentEntryType = string3;
                this.currentEntry = this.handleMatrixDefinition(attributes);
            } else if (RULEENTRY.equals(string3)) {
                this.currentEntryType = string3;
                this.currentEntry = this.handleRuleDefinition(attributes);
            } else if (REFERENCEENTRY.equals(string3)) {
                this.currentEntryType = string3;
                this.inDescription = true;
                this.currentEntry = this.handleReferenceDefinition(attributes);
            } else if (GLOSSARYENTRY.equals(string3)) {
                this.currentEntryType = string3;
                this.inDescription = true;
                this.currentEntry = this.handleGlossaryDefinition(attributes);
            } else if (WORDLIST.equals(string3)) {
                this.currentEntryType = string3;
                this.currentWordList = this.handleWordListDefinition(attributes);
            } else if (WORDLISTENTRY.equals(string3)) {
                this.handleWordListEntry(attributes);
            } else {
                this.handleComputationDefinition(string3, attributes);
            }
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) {
            if (this.inDescription && this.currentEntry != null && n3 > 0) {
                this.currentEntry.addDescription(cArray, n2, n3);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(DESCRIPTION) || string3.equals(GLOSSARYENTRY) || string3.equals(REFERENCEENTRY)) {
                this.inDescription = false;
                if (!string3.equals(DESCRIPTION)) {
                    this.currentEntry = null;
                }
            } else if (string3.equals(METRICENTRY) || string3.equals(SETENTRY) || string3.equals(RULEENTRY) || string3.equals(MATRIXENTRY)) {
                if (this.currentEntry.getAttributes() == null) {
                    this.reportError("No calculation procedure specified for " + string3 + " '" + this.currentEntry.getName() + "'.");
                }
                this.currentEntry = null;
            } else if (string3.equals(WORDLIST)) {
                this.currentWordList = null;
            }
        }

        @Override
        public void endDocument() {
            HashSet<MetaModelElement> hashSet = new HashSet<MetaModelElement>();
            for (MetaModelElement metaModelElement : MetricStore.this.metaModel) {
                this.processInheritance(metaModelElement, hashSet);
            }
        }

        private void processInheritance(MetaModelElement metaModelElement, HashSet<MetaModelElement> hashSet) {
            if (hashSet.contains(metaModelElement)) {
                return;
            }
            hashSet.add(metaModelElement);
            MetaModelElement metaModelElement2 = metaModelElement.getParent();
            if (metaModelElement2 == null) {
                return;
            }
            this.processInheritance(metaModelElement2, hashSet);
            new InheritanceProcessor<Metric>(){

                @Override
                Metric createCopy(Metric metric, MetaModelElement metaModelElement) {
                    return new Metric(metric, metaModelElement);
                }
            }.processInheritance(MetricStore.this.metrics, metaModelElement2, metaModelElement);
            new InheritanceProcessor<Set>(){

                @Override
                Set createCopy(Set set, MetaModelElement metaModelElement) {
                    return new Set(set, metaModelElement);
                }
            }.processInheritance(MetricStore.this.sets, metaModelElement2, metaModelElement);
            new InheritanceProcessor<Rule>(){

                @Override
                Rule createCopy(Rule rule, MetaModelElement metaModelElement) {
                    return new Rule(rule, metaModelElement);
                }
            }.processInheritance(MetricStore.this.rules, metaModelElement2, metaModelElement);
        }

        private Metric handleMetricDefinition(Attributes attributes) throws SAXException {
            String string = this.getEntryName(attributes);
            MetaModelElement metaModelElement = this.getTypeName(attributes, "domain");
            if (MetricStore.this.getMetric(metaModelElement, string) != null) {
                this.reportError("Duplicate definition of metric '" + string + "' for elements of type '" + metaModelElement.getName() + "'.");
            }
            String string2 = this.getOptionalAttribute(attributes, "category");
            Metric metric = new Metric(string, metaModelElement, string2);
            metric.setInternal("true".equals(attributes.getValue("internal")));
            this.setLocation(metric);
            this.setInheritability(metric, attributes);
            this.addEntry((Map)MetricStore.this.metrics.get(metaModelElement), metric);
            return metric;
        }

        private String getEntryName(Attributes attributes) throws SAXException {
            this.currentEntryName = attributes.getValue("name");
            if (this.currentEntryName == null) {
                this.reportError("No name specified for " + this.currentEntryType + ".");
            }
            return this.currentEntryName;
        }

        private MetaModelElement getTypeName(Attributes attributes, String string) throws SAXException {
            MetaModelElement metaModelElement;
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.reportError("No domain specified for " + this.currentEntryType + " '" + this.currentEntryName + "'.");
            }
            if ((metaModelElement = MetricStore.this.metaModel.getType(string2)) == null) {
                this.reportError("Unknown domain '" + string2 + "' for " + this.currentEntryType + " '" + this.currentEntryName + "'.");
            }
            return metaModelElement;
        }

        private String getOptionalAttribute(Attributes attributes, String string) {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                return "";
            }
            return string2;
        }

        private void setLocation(MetricEntry metricEntry) {
            if (this.locator != null) {
                metricEntry.setLocation(this.locator.getLineNumber());
            }
        }

        private void setInheritability(MetricEntry metricEntry, Attributes attributes) {
            boolean bl = MetricStore.this.defaultInheritability;
            String string = attributes.getValue(INHERITABLE);
            if (string != null) {
                bl = "true".equals(string);
            }
            metricEntry.setInheritable(bl);
        }

        private <T extends MetricEntry> void addEntry(Map<String, T> map, T t2) {
            t2.setId(map.size());
            map.put(t2.getName(), t2);
        }

        private Set handleSetDefinition(Attributes attributes) throws SAXException {
            String string = this.getEntryName(attributes);
            MetaModelElement metaModelElement = this.getTypeName(attributes, "domain");
            if (MetricStore.this.getSet(metaModelElement, string) != null) {
                this.reportError("Duplicate definition of set '" + string + "' for elements of type '" + metaModelElement.getName() + "'.");
            }
            Set set = new Set(string, metaModelElement);
            this.setLocation(set);
            this.setInheritability(set, attributes);
            String string2 = attributes.getValue("multiset");
            set.setMultiSet("true".equals(string2));
            this.addEntry((Map)MetricStore.this.sets.get(metaModelElement), set);
            return set;
        }

        private Matrix handleMatrixDefinition(Attributes attributes) throws SAXException {
            String string = this.getEntryName(attributes);
            MetaModelElement metaModelElement = this.getTypeName(attributes, "from_row_type");
            MetaModelElement metaModelElement2 = this.getTypeName(attributes, "to_col_type");
            Matrix matrix = new Matrix(string, metaModelElement, metaModelElement2);
            this.setLocation(matrix);
            matrix.setRowCondition(this.parseExpression(attributes, "row_condition"));
            matrix.setColumnCondition(this.parseExpression(attributes, "col_condition"));
            matrix.setId(MetricStore.this.matrices.size());
            MetricStore.this.matrices.add(matrix);
            return matrix;
        }

        private ExpressionNode parseExpression(Attributes attributes, String string) throws SAXException {
            ExpressionNode expressionNode = null;
            String string2 = attributes.getValue(string);
            if (string2 != null && (expressionNode = this.ep.parseExpression(string2)) == null) {
                this.reportError("Error parsing " + string + "='" + string2 + "' for " + this.currentEntryType + " '" + this.currentEntryName + "':\n" + this.ep.getErrorInfo());
            }
            return expressionNode;
        }

        private Rule handleRuleDefinition(Attributes attributes) throws SAXException {
            Object object;
            String string = this.getEntryName(attributes);
            MetaModelElement metaModelElement = this.getTypeName(attributes, "domain");
            if (MetricStore.this.getRule(metaModelElement, string) != null) {
                this.reportError("Duplicate definition of rule '" + string + "' for elements of type '" + metaModelElement.getName() + "'.");
            }
            String string2 = this.getOptionalAttribute(attributes, "category");
            String string3 = this.getOptionalAttribute(attributes, "severity");
            boolean bl = !"true".equals(attributes.getValue("disabled"));
            ArrayList<String> arrayList = null;
            String string4 = attributes.getValue("applies_to");
            if (string4 != null) {
                arrayList = new ArrayList<String>();
                object = new StringTokenizer(string4, " ,\t\n\r\f");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    arrayList.add(((StringTokenizer)object).nextToken());
                }
                if (arrayList.size() == 0) {
                    arrayList = null;
                }
            }
            object = new Rule(string, metaModelElement, string2, string3, arrayList, bl);
            this.setLocation((MetricEntry)object);
            this.setInheritability((MetricEntry)object, attributes);
            this.addEntry((Map)MetricStore.this.rules.get(metaModelElement), object);
            return object;
        }

        private MetricEntry handleReferenceDefinition(Attributes attributes) throws SAXException {
            String string = attributes.getValue("tag");
            if (string == null) {
                this.reportError("Reference is missing its tag.");
            }
            if (MetricStore.this.references.containsKey(string)) {
                this.reportError("Duplicate definition of reference '" + string + "'.");
            }
            Reference reference = new Reference(string);
            MetricStore.this.references.put(string, reference);
            return reference;
        }

        private Glossary handleGlossaryDefinition(Attributes attributes) throws SAXException {
            String string = this.getEntryName(attributes);
            if (MetricStore.this.glossary.containsKey(string)) {
                this.reportError("Duplicate definition of glossary term '" + string + "'.");
            }
            Glossary glossary = new Glossary(string);
            MetricStore.this.glossary.put(string, glossary);
            return glossary;
        }

        private WordList handleWordListDefinition(Attributes attributes) throws SAXException {
            String string = this.getEntryName(attributes);
            if (MetricStore.this.wordLists.containsKey(string)) {
                this.reportError("Duplicate definition of word list '" + string + "'.");
            }
            boolean bl = !"true".equals(attributes.getValue("ignorecase"));
            WordList wordList = new WordList(bl);
            MetricStore.this.wordLists.put(string, wordList);
            return wordList;
        }

        private void handleWordListEntry(Attributes attributes) throws SAXException {
            String string;
            if (this.currentWordList == null) {
                this.reportError("Wordlist entry outside of a word list.");
            }
            if ((string = attributes.getValue("word")) == null) {
                this.reportError("Wordlist entry missing 'word' attribute.");
            }
            this.currentWordList.addWord(string);
        }

        private void handleComputationDefinition(String string, Attributes attributes) throws SAXException {
            if (this.inDescription) {
                this.reportError("Unexpected XML element '" + string + "' in description.");
            }
            if (this.currentEntry == null) {
                this.reportError("Unexpected XML element '" + string + "' at this point.");
            }
            if (this.currentEntry.getAttributes() != null) {
                this.reportError("Unexpected XML element '" + string + "' - " + this.currentEntryType + " '" + this.currentEntryName + "' already has a calculation procedure.");
            }
            this.currentEntry.setProcedureName(string);
            ProcedureAttributes procedureAttributes = new ProcedureAttributes();
            int n2 = attributes.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = attributes.getQName(i2);
                ExpressionNode expressionNode = this.parseExpression(attributes, string2);
                if (string2.endsWith("_exp")) {
                    string2 = string2.substring(0, string2.length() - 4);
                }
                procedureAttributes.setExpressionNode(string2, expressionNode);
            }
            this.currentEntry.setAttributes(procedureAttributes);
        }

        private String handleProcedureDefinition(ProcedureCache<?> procedureCache, String string, Attributes attributes) throws SAXException {
            String string2;
            String string3 = attributes.getValue("name");
            if (string3 == null) {
                this.reportError("The " + string + " definition requires a 'name' attribute.");
            }
            if (procedureCache.hasProcedure(string3)) {
                this.reportError("The " + string + " '" + string3 + "' is already defined.");
            }
            if ((string2 = attributes.getValue("class")) == null) {
                this.reportError("No class defined for " + string + " definition '" + string3 + "'.");
            }
            try {
                procedureCache.addProcedureClass(string3, string2);
            }
            catch (SDMetricsException sDMetricsException) {
                this.reportError(sDMetricsException.getMessage());
            }
            return string3;
        }

        private abstract class InheritanceProcessor<T extends MetricEntry> {
            private InheritanceProcessor() {
            }

            abstract T createCopy(T var1, MetaModelElement var2);

            void processInheritance(HashMap<MetaModelElement, LinkedHashMap<String, T>> hashMap, MetaModelElement metaModelElement, MetaModelElement metaModelElement2) {
                Map map = hashMap.get(metaModelElement);
                Map map2 = hashMap.get(metaModelElement2);
                for (Map.Entry entry : map.entrySet()) {
                    MetricEntry metricEntry = (MetricEntry)entry.getValue();
                    if (!metricEntry.isInheritable() || map2.containsKey(entry.getKey())) continue;
                    MetricEntry metricEntry2 = this.createCopy(metricEntry, metaModelElement2);
                    MetricParser.this.addEntry(map2, metricEntry2);
                }
            }
        }
    }

    static class WordList {
        private boolean caseSensitive;
        private HashSet<String> words;

        WordList(boolean bl) {
            this.caseSensitive = bl;
            this.words = new HashSet();
        }

        void addWord(String string) {
            if (this.caseSensitive) {
                this.words.add(string);
            } else {
                this.words.add(string.toUpperCase());
            }
        }

        boolean hasWord(String string) {
            if (this.caseSensitive) {
                return this.words.contains(string);
            }
            return this.words.contains(string.toUpperCase());
        }
    }
}

