/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.metrics.FilterAttributeProcessor;
import com.sdmetrics.metrics.Metric;
import com.sdmetrics.metrics.MetricProcedure;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.SummationHelper;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;

public class MetricProcedureSubelements
extends MetricProcedure {
    @Override
    public Number calculate(ModelElement modelElement, Metric metric) throws SDMetricsException {
        ProcedureAttributes procedureAttributes = metric.getAttributes();
        FilterAttributeProcessor filterAttributeProcessor = this.getFilterAttributeProcessor(procedureAttributes);
        SummationHelper summationHelper = new SummationHelper(this.getMetricsEngine(), procedureAttributes);
        this.gatherSubelements(modelElement, filterAttributeProcessor, summationHelper, new Variables(modelElement));
        return summationHelper.getTotal();
    }

    private void gatherSubelements(ModelElement modelElement, FilterAttributeProcessor filterAttributeProcessor, SummationHelper summationHelper, Variables variables) throws SDMetricsException {
        Collection<ModelElement> collection = modelElement.getOwnedElements();
        if (collection == null) {
            return;
        }
        for (ModelElement modelElement2 : filterAttributeProcessor.fullIteration(collection, variables)) {
            if (filterAttributeProcessor.isValid()) {
                summationHelper.add(modelElement2, variables);
            }
            this.gatherSubelements(modelElement2, filterAttributeProcessor, summationHelper, variables);
        }
    }
}

