/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.metrics.FilterAttributeProcessor;
import com.sdmetrics.metrics.Metric;
import com.sdmetrics.metrics.MetricProcedure;
import com.sdmetrics.metrics.MetricTools;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.SummationHelper;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;

public class MetricProcedureProjection
extends MetricProcedure {
    @Override
    public Number calculate(ModelElement modelElement, Metric metric) throws SDMetricsException {
        Variables variables;
        ProcedureAttributes procedureAttributes = metric.getAttributes();
        Collection<ModelElement> collection = this.getRelationOrSet(modelElement, procedureAttributes, variables = new Variables(modelElement));
        if (collection == null || collection.isEmpty()) {
            return MetricTools.ZERO;
        }
        FilterAttributeProcessor filterAttributeProcessor = this.getFilterAttributeProcessor(procedureAttributes);
        SummationHelper summationHelper = new SummationHelper(this.getMetricsEngine(), procedureAttributes);
        boolean bl = procedureAttributes.getBooleanValue("recurse", false);
        boolean bl2 = procedureAttributes.getBooleanValue("nesting", false);
        for (ModelElement modelElement2 : filterAttributeProcessor.fullIteration(collection, variables)) {
            if (filterAttributeProcessor.isValid()) {
                if (bl2 && this.isCompatible(modelElement, metric, modelElement2)) {
                    summationHelper.raiseTo(1.0f + ((Number)this.getMetricsEngine().getMetricValue(modelElement2, metric)).floatValue());
                    continue;
                }
                summationHelper.add(modelElement2, variables);
            }
            if (!bl || !this.isCompatible(modelElement, metric, modelElement2)) continue;
            summationHelper.add(((Number)this.getMetricsEngine().getMetricValue(modelElement2, metric)).floatValue());
        }
        return summationHelper.getTotal();
    }
}

