/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.FilterAttributeProcessor;
import com.sdmetrics.metrics.Metric;
import com.sdmetrics.metrics.MetricProcedure;
import com.sdmetrics.metrics.MetricTools;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;

public class MetricProcedureCount
extends MetricProcedure {
    @Override
    public Integer calculate(ModelElement modelElement, Metric metric) throws SDMetricsException {
        ProcedureAttributes procedureAttributes = metric.getAttributes();
        Variables variables = new Variables(modelElement);
        Object object = this.evalExpression(modelElement, procedureAttributes.getRequiredExpression("term"), variables);
        variables.setVariable("term", object);
        Collection<ModelElement> collection = this.evalElementSetExpression(modelElement, procedureAttributes.getRequiredExpression("set"), variables);
        if (collection.isEmpty()) {
            return MetricTools.ZERO;
        }
        FilterAttributeProcessor filterAttributeProcessor = this.getFilterAttributeProcessor(procedureAttributes);
        ExpressionNode expressionNode = procedureAttributes.getExpression("relset");
        if (expressionNode == null) {
            return MetricTools.elementCount(collection, object);
        }
        int n2 = 0;
        variables.setVariable("set", collection);
        for (ModelElement modelElement2 : filterAttributeProcessor.validIteration(collection, variables)) {
            Collection<?> collection2 = this.evalSetExpression(modelElement2, expressionNode, variables);
            n2 += MetricTools.elementCount(collection2, object);
        }
        return n2;
    }
}

