/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.ChangeDirectionsAdapter;
import com.sdmetrics.metrics.ElementGraph;
import com.sdmetrics.metrics.Metric;
import com.sdmetrics.metrics.MetricProcedure;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.StronglyConnectedComponents;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;

public class MetricProcedureConnectedComponents
extends MetricProcedure {
    @Override
    public Integer calculate(ModelElement modelElement, Metric metric) throws SDMetricsException {
        return this.connectedComponents(modelElement, metric).getConnectedComponentCount();
    }

    private StronglyConnectedComponents<ModelElement> connectedComponents(ModelElement modelElement, Metric metric) throws SDMetricsException {
        ProcedureAttributes procedureAttributes = metric.getAttributes();
        Variables variables = new Variables(modelElement);
        int n2 = 1;
        ExpressionNode expressionNode = procedureAttributes.getExpression("minnodes");
        if (expressionNode != null) {
            n2 = ((Number)this.evalExpression(modelElement, expressionNode, variables)).intValue();
        }
        Collection<ModelElement> collection = this.evalElementSetExpression(modelElement, procedureAttributes.getRequiredExpression("set"), variables);
        ExpressionNode expressionNode2 = procedureAttributes.getRequiredExpression("nodes");
        StronglyConnectedComponents.Graph<ModelElement> graph = new ElementGraph(this.getMetricsEngine(), collection, expressionNode2, variables);
        boolean bl = procedureAttributes.getBooleanValue("undirected", false);
        if (bl) {
            graph = new ChangeDirectionsAdapter<ModelElement>(graph, true);
        }
        StronglyConnectedComponents<ModelElement> stronglyConnectedComponents = new StronglyConnectedComponents<ModelElement>();
        stronglyConnectedComponents.calculateConnectedComponents(graph, n2, false);
        return stronglyConnectedComponents;
    }

    public StronglyConnectedComponents<ModelElement> getConnectedComponents(MetricsEngine metricsEngine, ModelElement modelElement, Metric metric) throws SDMetricsException {
        this.setMetricsEngine(metricsEngine);
        return this.connectedComponents(modelElement, metric);
    }
}

