/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.IntegerMatrix;
import com.sdmetrics.metrics.Matrix;
import com.sdmetrics.metrics.MatrixData;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Set;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.Model;
import com.sdmetrics.model.ModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class MatrixEngine {
    private MetricsEngine engine;
    private Model model;
    private Set proxy;

    public MatrixEngine(MetricsEngine metricsEngine) {
        this.engine = metricsEngine;
        this.model = metricsEngine.getModel();
        this.proxy = new Set("dummy", metricsEngine.getMetaModel().getType("sdmetricsbase"));
        this.proxy.setMultiSet(true);
    }

    public MetricsEngine getMetricsEngine() {
        return this.engine;
    }

    public MatrixData calculate(Matrix matrix) throws SDMetricsException {
        List<ModelElement> list = this.getElementList(matrix.getRowType(), matrix.getRowCondition());
        List<ModelElement> list2 = this.getElementList(matrix.getColumnType(), matrix.getColumnCondition());
        HashMap<ModelElement, Integer> hashMap = new HashMap<ModelElement, Integer>();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            hashMap.put(list2.get(i2), i2);
        }
        ProcedureAttributes procedureAttributes = matrix.getAttributes();
        this.proxy.setAttributes(procedureAttributes);
        String string = matrix.getProcedureName();
        if ("setoperation".equals(string)) {
            string = "compoundset";
        }
        this.proxy.setProcedureName(string);
        IntegerMatrix integerMatrix = new IntegerMatrix();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            Collection<?> collection = this.engine.computeSet(list.get(i3), this.proxy);
            for (Object obj : collection) {
                Integer n2 = (Integer)hashMap.get(obj);
                if (n2 == null) continue;
                integerMatrix.increment(i3, n2);
            }
        }
        return new MatrixData(matrix, list, list2, integerMatrix);
    }

    private List<ModelElement> getElementList(MetaModelElement metaModelElement, ExpressionNode expressionNode) throws SDMetricsException {
        List<ModelElement> list = this.model.getAcceptedElements(metaModelElement);
        if (expressionNode == null) {
            return list;
        }
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : list) {
            if (!this.engine.evalBooleanExpression(modelElement, expressionNode, null)) continue;
            arrayList.add(modelElement);
        }
        return arrayList;
    }
}

