/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterAttributeProcessor {
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_TARGETCOND = "targetcondition";
    private static final String ATTR_ELEMENT = "element";
    private static final String ATTR_ELTYPE = "eltype";
    private static final String ATTR_CONDEXP = "condition";
    private static final String ATTR_SCOPE = "scope";
    private static final String IDEM = "idem";
    private static final String NOTIDEM = "notidem";
    private static final String CONTAINEDIN = "containedin";
    private static final String NOTCONTAINEDIN = "notcontainedin";
    private static final String SAME = "same";
    private static final String OTHER = "other";
    private static final String HIGHER = "higher";
    private static final String LOWER = "lower";
    private static final String SAMEORHIGHER = "sameorhigher";
    private static final String SAMEORLOWER = "sameorlower";
    private static final String NOTHIGHER = "nothigher";
    private static final String NOTLOWER = "notlower";
    private static final String SAMEBRANCH = "samebranch";
    private static final String NOTSAMEBRANCH = "notsamebranch";
    private MetricsEngine engine;
    private ExpressionNode targetExpr;
    private ExpressionNode targetConditionExpr;
    private ExpressionNode elementExpr;
    private ExpressionNode eltypeExprt;
    private ExpressionNode conditionExpr;
    private String scope;
    private boolean valid;

    public FilterAttributeProcessor(MetricsEngine metricsEngine, ProcedureAttributes procedureAttributes) throws SDMetricsException {
        this.engine = metricsEngine;
        this.targetExpr = procedureAttributes.getExpression(ATTR_TARGET);
        this.targetConditionExpr = procedureAttributes.getExpression(ATTR_TARGETCOND);
        this.elementExpr = procedureAttributes.getExpression(ATTR_ELEMENT);
        this.eltypeExprt = procedureAttributes.getExpression(ATTR_ELTYPE);
        this.conditionExpr = procedureAttributes.getExpression(ATTR_CONDEXP);
        this.scope = procedureAttributes.getStringValue(ATTR_SCOPE);
    }

    public ModelElement applyFilters(ModelElement modelElement, ModelElement modelElement2, Variables variables) throws SDMetricsException {
        this.valid = this.checkType(modelElement2.getType(), this.targetExpr);
        if (this.valid && this.targetConditionExpr != null) {
            this.valid = this.engine.evalBooleanExpression(modelElement2, this.targetConditionExpr, variables);
        }
        ModelElement modelElement3 = modelElement2;
        if (this.valid && this.elementExpr != null) {
            modelElement3 = this.engine.evalModelElementExpression(modelElement2, this.elementExpr, variables);
            if (modelElement3 == null) {
                return null;
            }
            this.valid = this.checkType(modelElement3.getType(), this.eltypeExprt);
        }
        if (this.valid && this.conditionExpr != null) {
            this.valid = this.engine.evalBooleanExpression(modelElement3, this.conditionExpr, variables);
        }
        if (this.valid && this.scope != null) {
            this.valid = this.checkScope(modelElement, modelElement3);
        }
        return modelElement3;
    }

    public boolean isValid() {
        return this.valid;
    }

    private boolean checkType(MetaModelElement metaModelElement, ExpressionNode expressionNode) throws SDMetricsException {
        MetaModelElement metaModelElement2;
        boolean bl;
        if (expressionNode == null) {
            return true;
        }
        boolean bl2 = bl = expressionNode.isOperation() && "+".equals(expressionNode.getValue()) && expressionNode.getOperandCount() == 1;
        if (expressionNode.isOperation() && !bl) {
            if (this.checkType(metaModelElement, expressionNode.getLeftNode())) {
                return true;
            }
            if (expressionNode.getRightNode() != null) {
                return this.checkType(metaModelElement, expressionNode.getRightNode());
            }
            return false;
        }
        ExpressionNode expressionNode2 = expressionNode;
        if (bl) {
            expressionNode2 = expressionNode.getLeftNode();
        }
        if ((metaModelElement2 = this.engine.getMetaModel().getType(expressionNode2.getValue())) == null) {
            throw new SDMetricsException(null, null, "Unknown model element type '" + expressionNode2.getValue() + "'.");
        }
        if (bl) {
            return metaModelElement.specializes(metaModelElement2);
        }
        return metaModelElement == metaModelElement2;
    }

    private boolean checkScope(ModelElement modelElement, ModelElement modelElement2) throws SDMetricsException {
        boolean bl;
        ModelElement modelElement3;
        boolean bl2;
        if (this.scope.equals(IDEM)) {
            return modelElement == modelElement2;
        }
        if (this.scope.equals(NOTIDEM)) {
            return modelElement != modelElement2;
        }
        if (this.scope.equals(CONTAINEDIN)) {
            return this.contains(modelElement, modelElement2);
        }
        if (this.scope.equals(NOTCONTAINEDIN)) {
            return !this.contains(modelElement, modelElement2);
        }
        ModelElement modelElement4 = modelElement.getOwner();
        boolean bl3 = bl2 = modelElement4 == (modelElement3 = modelElement2.getOwner());
        if (this.scope.equals(SAME)) {
            return bl2;
        }
        if (this.scope.equals(OTHER)) {
            return !bl2;
        }
        boolean bl4 = this.contains(modelElement4, modelElement3);
        if (this.scope.equals(LOWER)) {
            return bl4;
        }
        if (this.scope.equals(NOTLOWER)) {
            return !bl4;
        }
        if (this.scope.equals(SAMEORLOWER)) {
            return bl2 || bl4;
        }
        boolean bl5 = this.contains(modelElement3, modelElement4);
        if (this.scope.equals(HIGHER)) {
            return bl5;
        }
        if (this.scope.equals(NOTHIGHER)) {
            return !bl5;
        }
        if (this.scope.equals(SAMEORHIGHER)) {
            return bl2 || bl5;
        }
        boolean bl6 = bl = bl2 || bl4 || bl5;
        if (this.scope.equals(SAMEBRANCH)) {
            return bl;
        }
        if (this.scope.equals(NOTSAMEBRANCH)) {
            return !bl;
        }
        throw new SDMetricsException(null, null, "Illegal scope criterion '" + this.scope + "'.");
    }

    private boolean contains(ModelElement modelElement, ModelElement modelElement2) {
        if (modelElement2 == null) {
            return false;
        }
        for (ModelElement modelElement3 = modelElement2.getOwner(); modelElement3 != null; modelElement3 = modelElement3.getOwner()) {
            if (modelElement3 != modelElement) continue;
            return true;
        }
        return false;
    }

    public Iterable<ModelElement> fullIteration(final Collection<ModelElement> collection, final Variables variables) throws SDMetricsException {
        return new Iterable<ModelElement>(){

            @Override
            public Iterator<ModelElement> iterator() {
                FilteringIterator filteringIterator = new FilteringIterator(collection, variables);
                filteringIterator.returnValidsOnly = false;
                return filteringIterator;
            }
        };
    }

    public Iterable<ModelElement> validIteration(final Collection<ModelElement> collection, final Variables variables) throws SDMetricsException {
        return new Iterable<ModelElement>(){

            @Override
            public Iterator<ModelElement> iterator() {
                FilteringIterator filteringIterator = new FilteringIterator(collection, variables);
                filteringIterator.returnValidsOnly = true;
                return filteringIterator;
            }
        };
    }

    private class FilteringIterator
    implements Iterator<ModelElement> {
        private Iterator<ModelElement> it;
        private boolean hasNext = false;
        private ModelElement next = null;
        private boolean nextKnown = false;
        private Variables variables;
        private ModelElement principal;
        boolean returnValidsOnly = false;

        FilteringIterator(Collection<ModelElement> collection, Variables variables) {
            this.variables = variables;
            this.principal = variables.getPrincipal();
            this.it = collection.iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.nextKnown) {
                this.findNext();
            }
            return this.hasNext;
        }

        @Override
        public ModelElement next() {
            if (!this.nextKnown) {
                this.findNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.nextKnown = false;
            return this.next;
        }

        private void findNext() throws SDMetricsException {
            this.nextKnown = true;
            while (this.it.hasNext()) {
                ModelElement modelElement = this.it.next();
                if (modelElement.getLinksIgnored() || (modelElement = FilterAttributeProcessor.this.applyFilters(this.principal, modelElement, this.variables)) == null || this.returnValidsOnly && !FilterAttributeProcessor.this.isValid()) continue;
                this.hasNext = true;
                this.next = modelElement;
                return;
            }
            this.hasNext = false;
            this.next = null;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

