/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.ExpressionParser;
import com.sdmetrics.math.HashMultiSet;
import com.sdmetrics.metrics.AbstractProcedure;
import com.sdmetrics.metrics.BooleanOperation;
import com.sdmetrics.metrics.MetricTools;
import com.sdmetrics.metrics.ProcedureCache;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.ScalarOperation;
import com.sdmetrics.metrics.SetOperation;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.ModelElement;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

class ExpressionOperations {
    private ScalarOperationCache scalarOperations;
    private BooleanOperationCache booleanOperations;
    private SetOperationCache setOperations;
    private HashSet<String> functionNames = new HashSet();
    private HashSet<String> highPrecedenceRelationNames = new HashSet();
    private HashSet<String> lowPrecedenceRelationNames = new HashSet();

    ExpressionOperations() {
        this.scalarOperations = new ScalarOperationCache();
        this.booleanOperations = new BooleanOperationCache();
        this.setOperations = new SetOperationCache();
    }

    private <T extends AbstractProcedure> void addProcedure(ProcedureCache<T> procedureCache, String string, Class<? extends T> clazz, HashSet<String> hashSet) {
        procedureCache.addProcedureClass(string, clazz);
        hashSet.add(string);
    }

    ProcedureCache<ScalarOperation> getScalarOperations() {
        return this.scalarOperations;
    }

    ProcedureCache<BooleanOperation> getBooleanOperations() {
        return this.booleanOperations;
    }

    ProcedureCache<SetOperation> getSetOperations() {
        return this.setOperations;
    }

    void addCustomFunctionName(String string) {
        this.functionNames.add(string);
    }

    ExpressionParser getExpressionParser() {
        return new ExpressionParser(this.functionNames, this.highPrecedenceRelationNames, this.lowPrecedenceRelationNames);
    }

    public static class IntersectionOperation
    extends BinarySetOperation {
        @Override
        public Collection<?> calculateValue(Collection<?> collection, Collection<?> collection2) {
            boolean bl = MetricTools.isMultiSet(collection2) && MetricTools.isMultiSet(collection);
            Collection<?> collection3 = MetricTools.createHashSet(bl, collection);
            collection3.retainAll(collection2);
            return collection3;
        }
    }

    public static class DifferenceOperation
    extends BinarySetOperation {
        @Override
        public Collection<?> calculateValue(Collection<?> collection, Collection<?> collection2) {
            Collection<?> collection3 = MetricTools.createHashSet(MetricTools.isMultiSet(collection), collection);
            collection3.removeAll(collection2);
            return collection3;
        }
    }

    public static class UnionOperation
    extends BinarySetOperation {
        @Override
        public Collection<?> calculateValue(Collection<?> collection, Collection<?> collection2) {
            boolean bl = MetricTools.isMultiSet(collection2) || MetricTools.isMultiSet(collection);
            Collection<?> collection3 = MetricTools.createHashSet(bl, collection);
            collection3.addAll(collection2);
            return collection3;
        }
    }

    static abstract class BinarySetOperation
    extends SetOperation {
        BinarySetOperation() {
        }

        @Override
        public Collection<?> calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Collection<?> collection = this.evalSetExpression(modelElement, expressionNode.getLeftNode(), variables);
            Collection<?> collection2 = this.evalSetExpression(modelElement, expressionNode.getRightNode(), variables);
            return this.calculateValue(collection, collection2);
        }

        public abstract Collection<?> calculateValue(Collection<?> var1, Collection<?> var2);
    }

    public static class DotOperatorSet
    extends SetOperation {
        @Override
        public Collection<?> calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (object == null || !(object instanceof ModelElement)) {
                return Collections.EMPTY_SET;
            }
            try {
                return this.evalSetExpression((ModelElement)object, expressionNode.getRightNode(), variables);
            }
            catch (Exception exception) {
                return Collections.EMPTY_SET;
            }
        }
    }

    public static class EndsWithOperator
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            Object object2 = this.evalExpression(modelElement, expressionNode.getRightNode(), variables);
            return object.toString().endsWith(object2.toString());
        }
    }

    public static class StartsWithOperator
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            Object object2 = this.evalExpression(modelElement, expressionNode.getRightNode(), variables);
            return object.toString().startsWith(object2.toString());
        }
    }

    public static class LessOrEqualOperator
    extends BooleanComparator {
        @Override
        protected boolean compare(float f2, float f3) {
            return f2 <= f3;
        }

        @Override
        protected boolean compare(Object object, Object object2) {
            int n2 = object.toString().compareTo(object2.toString());
            return n2 <= 0;
        }
    }

    public static class LessThanOperator
    extends BooleanComparator {
        @Override
        protected boolean compare(float f2, float f3) {
            return f2 < f3;
        }

        @Override
        protected boolean compare(Object object, Object object2) {
            int n2 = object.toString().compareTo(object2.toString());
            return n2 < 0;
        }
    }

    public static class GreaterOrEqualOperator
    extends BooleanComparator {
        @Override
        protected boolean compare(float f2, float f3) {
            return f2 >= f3;
        }

        @Override
        protected boolean compare(Object object, Object object2) {
            int n2 = object.toString().compareTo(object2.toString());
            return n2 >= 0;
        }
    }

    public static class GreaterThanOperator
    extends BooleanComparator {
        @Override
        protected boolean compare(float f2, float f3) {
            return f2 > f3;
        }

        @Override
        protected boolean compare(Object object, Object object2) {
            int n2 = object.toString().compareTo(object2.toString());
            return n2 > 0;
        }
    }

    public static class NotEqualsOperator
    extends BooleanComparator {
        @Override
        protected boolean compare(float f2, float f3) {
            return f2 != f3;
        }

        @Override
        protected boolean compare(Object object, Object object2) {
            return !object.equals(object2);
        }
    }

    public static class EqualsOperator
    extends BooleanComparator {
        @Override
        protected boolean compare(float f2, float f3) {
            return f2 == f3;
        }

        @Override
        protected boolean compare(Object object, Object object2) {
            return object.equals(object2);
        }
    }

    static abstract class BooleanComparator
    extends BooleanOperation {
        BooleanComparator() {
        }

        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            Object object2 = this.evalExpression(modelElement, expressionNode.getRightNode(), variables);
            if (object instanceof Number && object2 instanceof Number) {
                float f2 = ((Number)object).floatValue();
                float f3 = ((Number)object2).floatValue();
                return this.compare(f2, f3);
            }
            return this.compare(object, object2);
        }

        protected abstract boolean compare(float var1, float var2);

        protected abstract boolean compare(Object var1, Object var2);
    }

    public static class OnListOperator
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            ExpressionNode expressionNode2 = expressionNode.getRightNode();
            String string = expressionNode2.isIdentifier() || expressionNode2.isStringConstant() ? expressionNode2.getValue() : this.evalExpression(modelElement, expressionNode2, variables).toString();
            return this.getMetricsEngine().getMetricStore().isWordOnList(object.toString(), string);
        }
    }

    public static class InOperatorBool
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            Collection<?> collection = this.evalSetExpression(modelElement, expressionNode.getRightNode(), variables);
            return collection.contains(object);
        }
    }

    public static class InstanceOfFunction
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object;
            ModelElement modelElement2 = modelElement;
            if (expressionNode.getOperandCount() == 2) {
                object = this.evalExpression(modelElement, expressionNode.getOperand(0), variables);
                if (MetricTools.isEmptyElement(object)) {
                    return false;
                }
                if (!(object instanceof ModelElement)) {
                    throw new SDMetricsException(modelElement, null, "First argument of binary function " + expressionNode.getValue() + " must yield a model element");
                }
                modelElement2 = (ModelElement)object;
            }
            object = this.evalExpression(modelElement, expressionNode.getOperand(expressionNode.getOperandCount() - 1), variables);
            MetaModelElement metaModelElement = null;
            metaModelElement = object instanceof ModelElement ? ((ModelElement)object).getType() : this.getMetaModel().getType(object.toString());
            if (metaModelElement == null) {
                throw new SDMetricsException(modelElement, null, "Unknown base type '" + object.toString() + "'");
            }
            return modelElement2.getType().specializes(metaModelElement);
        }
    }

    public static class IsLowerCaseFunction
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            String string = object.toString();
            return string.equals(string.toLowerCase());
        }
    }

    public static class StartsWithLowerCaseFunction
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            String string = object.toString();
            if (string.length() < 1) {
                return true;
            }
            return string.charAt(0) == Character.toLowerCase(string.charAt(0));
        }
    }

    public static class StartsWithCapitalFunction
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            String string = object.toString();
            if (string.length() < 1) {
                return true;
            }
            return string.charAt(0) == Character.toUpperCase(string.charAt(0));
        }
    }

    public static class IsUniqueFunction
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Collection<?> collection = this.evalSetExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (!MetricTools.isMultiSet(collection)) {
                return true;
            }
            return collection.size() == ((HashMultiSet)collection).flatSetSize();
        }
    }

    public static class NotOperator
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            return !this.evalBooleanExpression(modelElement, expressionNode.getLeftNode(), variables);
        }
    }

    public static class OrOperator
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            if (!this.evalBooleanExpression(modelElement, expressionNode.getLeftNode(), variables)) {
                return this.evalBooleanExpression(modelElement, expressionNode.getRightNode(), variables);
            }
            return true;
        }
    }

    public static class AndOperator
    extends BooleanOperation {
        @Override
        public boolean calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            if (this.evalBooleanExpression(modelElement, expressionNode.getLeftNode(), variables)) {
                return this.evalBooleanExpression(modelElement, expressionNode.getRightNode(), variables);
            }
            return false;
        }
    }

    public static class RoundFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return (float)Math.floor((double)f2 + 0.5);
        }
    }

    public static class CeilingFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return (float)Math.ceil(f2);
        }
    }

    public static class FloorFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return (float)Math.floor(f2);
        }
    }

    public static class AbsoluteFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return Math.abs(f2);
        }
    }

    public static class SquareRootFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return (float)Math.sqrt(f2);
        }
    }

    public static class ExponentiationFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return (float)Math.exp(f2);
        }
    }

    public static class LogarithmFunction
    extends UnaryNumericalOperator {
        @Override
        protected float calculateValue(float f2) {
            return (float)Math.log(f2);
        }
    }

    static abstract class UnaryNumericalOperator
    extends ScalarOperation {
        UnaryNumericalOperator() {
        }

        @Override
        public final Float calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            float f2 = this.getFloatValue(modelElement, expressionNode.getLeftNode(), variables);
            return Float.valueOf(this.calculateValue(f2));
        }

        protected abstract float calculateValue(float var1);
    }

    public static class ExponentiationOperator
    extends BinaryNumericalOperator {
        @Override
        protected float calculateValue(float f2, float f3) {
            return (float)Math.pow(f2, f3);
        }
    }

    public static class DivisionOperator
    extends BinaryNumericalOperator {
        @Override
        protected float calculateValue(float f2, float f3) {
            return f2 / f3;
        }
    }

    public static class MultiplicationOperator
    extends BinaryNumericalOperator {
        @Override
        protected float calculateValue(float f2, float f3) {
            return f2 * f3;
        }
    }

    static abstract class BinaryNumericalOperator
    extends ScalarOperation {
        BinaryNumericalOperator() {
        }

        @Override
        public final Float calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            float f2 = this.getFloatValue(modelElement, expressionNode.getLeftNode(), variables);
            float f3 = this.getFloatValue(modelElement, expressionNode.getRightNode(), variables);
            return Float.valueOf(this.calculateValue(f2, f3));
        }

        protected abstract float calculateValue(float var1, float var2);
    }

    public static class MinusOperator
    extends ScalarOperation {
        @Override
        public Float calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            float f2 = this.getFloatValue(modelElement, expressionNode.getLeftNode(), variables);
            if (expressionNode.getOperandCount() == 1) {
                return new Float(-f2);
            }
            float f3 = this.getFloatValue(modelElement, expressionNode.getRightNode(), variables);
            return Float.valueOf(f2 - f3);
        }
    }

    public static class PlusOperator
    extends ScalarOperation {
        @Override
        public Object calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (expressionNode.getOperandCount() == 1) {
                return object;
            }
            if (!(object instanceof Number)) {
                Object object2 = this.evalExpression(modelElement, expressionNode.getRightNode(), variables);
                if (object2 instanceof Number) {
                    return object.toString() + NumberFormat.getInstance().format(object2);
                }
                return object.toString() + object2.toString();
            }
            float f2 = this.getFloatValue(object, modelElement);
            float f3 = this.getFloatValue(modelElement, expressionNode.getRightNode(), variables);
            return Float.valueOf(f2 + f3);
        }
    }

    public static class InOperator
    extends ScalarOperation {
        @Override
        public Object calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            ExpressionNode expressionNode2 = expressionNode.getRightNode();
            Collection<?> collection = this.evalSetExpression(modelElement, expressionNode2, variables);
            return MetricTools.elementCount(collection, object);
        }
    }

    public static class TopMostOperator
    extends ScalarOperation {
        @Override
        public Object calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            Object object2 = "";
            while (object != null) {
                if (object instanceof ModelElement) {
                    ModelElement modelElement2 = (ModelElement)object;
                    if (this.evalBooleanExpression(modelElement2, expressionNode.getRightNode(), variables)) {
                        object2 = modelElement2;
                    }
                    object = this.evalExpression(modelElement2, expressionNode.getLeftNode(), variables);
                    continue;
                }
                object = null;
            }
            return object2;
        }
    }

    public static class UpToOperator
    extends ScalarOperation {
        @Override
        public Object calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            while (object != null) {
                if (object instanceof ModelElement) {
                    ModelElement modelElement2 = (ModelElement)object;
                    if (this.evalBooleanExpression(modelElement2, expressionNode.getRightNode(), variables)) {
                        return modelElement2;
                    }
                    object = this.evalExpression(modelElement2, expressionNode.getLeftNode(), variables);
                    continue;
                }
                object = null;
            }
            return "";
        }
    }

    public static class DotOperator
    extends ScalarOperation {
        @Override
        public Object calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (object == null || !(object instanceof ModelElement)) {
                return "";
            }
            try {
                return this.evalExpression((ModelElement)object, expressionNode.getRightNode(), variables);
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    public static class QualifiedNameFunction
    extends ScalarOperation {
        @Override
        public String calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (object instanceof ModelElement) {
                ModelElement modelElement2 = (ModelElement)object;
                return modelElement2.getFullName();
            }
            if (MetricTools.isEmptyElement(object)) {
                return "";
            }
            throw new SDMetricsException(modelElement, null, "Operator '" + expressionNode.getValue() + "' can only be applied to model elements.");
        }
    }

    public static class TypeOfFunction
    extends ScalarOperation {
        @Override
        public String calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (object instanceof ModelElement) {
                ModelElement modelElement2 = (ModelElement)object;
                return modelElement2.getType().getName();
            }
            if (MetricTools.isEmptyElement(object)) {
                return "";
            }
            throw new SDMetricsException(modelElement, null, "Operator '" + expressionNode.getValue() + "' can only be applied to model elements.");
        }
    }

    public static class ToLowerFunction
    extends ScalarOperation {
        @Override
        public String calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            return object.toString().toLowerCase();
        }
    }

    public static class LengthFunction
    extends ScalarOperation {
        @Override
        public Integer calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Object object = this.evalExpression(modelElement, expressionNode.getLeftNode(), variables);
            return object.toString().length();
        }
    }

    public static class FlatSizeFunction
    extends ScalarOperation {
        @Override
        public Integer calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Collection<?> collection = this.evalSetExpression(modelElement, expressionNode.getLeftNode(), variables);
            if (MetricTools.isMultiSet(collection)) {
                return ((HashMultiSet)collection).flatSetSize();
            }
            return collection.size();
        }
    }

    public static class SizeFunction
    extends ScalarOperation {
        @Override
        public Integer calculateValue(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
            Collection<?> collection = this.evalSetExpression(modelElement, expressionNode.getLeftNode(), variables);
            return collection.size();
        }
    }

    class SetOperationCache
    extends ProcedureCache<SetOperation> {
        SetOperationCache() {
            super("set operation");
            this.addProcedureClass(".", DotOperatorSet.class);
            this.addProcedureClass("+", UnionOperation.class);
            this.addProcedureClass("-", DifferenceOperation.class);
            this.addProcedureClass("*", IntersectionOperation.class);
        }

        @Override
        protected Class<? extends SetOperation> loadClass(String string) throws Exception {
            return Class.forName(string).asSubclass(SetOperation.class);
        }
    }

    class BooleanOperationCache
    extends ProcedureCache<BooleanOperation> {
        BooleanOperationCache() {
            super("boolean operation");
            this.addProcedureClass("&", AndOperator.class);
            this.addProcedureClass("|", OrOperator.class);
            this.addProcedureClass("!", NotOperator.class);
            ExpressionOperations.this.addProcedure(this, "isunique", IsUniqueFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "startswithcapital", StartsWithCapitalFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "startswithlowercase", StartsWithLowerCaseFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "islowercase", IsLowerCaseFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "instanceof", InstanceOfFunction.class, ExpressionOperations.this.functionNames);
            this.addProcedureClass("->", InOperatorBool.class);
            ExpressionOperations.this.addProcedure(this, "onlist", OnListOperator.class, ExpressionOperations.this.highPrecedenceRelationNames);
            this.addProcedureClass("=", EqualsOperator.class);
            this.addProcedureClass("!=", NotEqualsOperator.class);
            this.addProcedureClass(">", GreaterThanOperator.class);
            this.addProcedureClass(">=", GreaterOrEqualOperator.class);
            this.addProcedureClass("<", LessThanOperator.class);
            this.addProcedureClass("<=", LessOrEqualOperator.class);
            ExpressionOperations.this.addProcedure(this, "startswith", StartsWithOperator.class, ExpressionOperations.this.highPrecedenceRelationNames);
            ExpressionOperations.this.addProcedure(this, "endswith", EndsWithOperator.class, ExpressionOperations.this.highPrecedenceRelationNames);
        }

        @Override
        protected Class<? extends BooleanOperation> loadClass(String string) throws Exception {
            return Class.forName(string).asSubclass(BooleanOperation.class);
        }
    }

    class ScalarOperationCache
    extends ProcedureCache<ScalarOperation> {
        ScalarOperationCache() {
            super("operation");
            ExpressionOperations.this.addProcedure(this, "size", SizeFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "flatsize", FlatSizeFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "length", LengthFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "tolowercase", ToLowerFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "typeof", TypeOfFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "qualifiedname", QualifiedNameFunction.class, ExpressionOperations.this.functionNames);
            this.addProcedureClass(".", DotOperator.class);
            ExpressionOperations.this.addProcedure(this, "upto", UpToOperator.class, ExpressionOperations.this.lowPrecedenceRelationNames);
            ExpressionOperations.this.addProcedure(this, "topmost", TopMostOperator.class, ExpressionOperations.this.lowPrecedenceRelationNames);
            this.addProcedureClass("->", InOperator.class);
            this.addProcedureClass("+", PlusOperator.class);
            this.addProcedureClass("-", MinusOperator.class);
            this.addProcedureClass("*", MultiplicationOperator.class);
            this.addProcedureClass("/", DivisionOperator.class);
            this.addProcedureClass("^", ExponentiationOperator.class);
            ExpressionOperations.this.addProcedure(this, "ln", LogarithmFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "exp", ExponentiationFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "sqrt", SquareRootFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "abs", AbsoluteFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "floor", FloorFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "ceil", CeilingFunction.class, ExpressionOperations.this.functionNames);
            ExpressionOperations.this.addProcedure(this, "round", RoundFunction.class, ExpressionOperations.this.functionNames);
        }

        @Override
        protected Class<? extends ScalarOperation> loadClass(String string) throws Exception {
            return Class.forName(string).asSubclass(ScalarOperation.class);
        }
    }
}

