/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.metrics.DescriptionLocator;

class Description {
    private StringBuilder text = new StringBuilder();
    private String description = null;
    private String descriptionSeparator = ".";

    Description() {
    }

    void add(char[] cArray, int n2, int n3) {
        int n4;
        int n5 = n2;
        if (this.text.length() == 0) {
            for (n4 = n3; n4 > 0 && Character.isWhitespace(cArray[n5]); --n4) {
                ++n5;
            }
        }
        if (n4 > 0) {
            this.text.append(cArray, n5, n4);
        }
    }

    void setSeparator(String string) {
        this.descriptionSeparator = string;
    }

    String getBriefDescription() {
        this.getDescription();
        int n2 = this.description.indexOf(this.descriptionSeparator, 0);
        if (n2 < 0) {
            return this.description;
        }
        return this.description.substring(0, n2 + this.descriptionSeparator.length());
    }

    String getDescription() {
        if (this.description == null) {
            Description.processHTML(this.text);
            this.description = this.text.toString();
            this.text = null;
        }
        return this.description;
    }

    private static void processHTML(StringBuilder stringBuilder) {
        Description.replaceAll(stringBuilder, "((", "<");
        Description.replaceAll(stringBuilder, "))", ">");
        Description.replaceAll(stringBuilder, "\n", " ");
        for (DescriptionLocator descriptionLocator : DescriptionLocator.values()) {
            Description.replaceLinks(stringBuilder, descriptionLocator);
        }
    }

    private static void replaceAll(StringBuilder stringBuilder, String string, String string2) {
        int n2 = 0;
        while ((n2 = stringBuilder.indexOf(string, n2)) >= 0) {
            stringBuilder.replace(n2, n2 + string.length(), string2);
            n2 += string2.length();
        }
    }

    private static void replaceLinks(StringBuilder stringBuilder, DescriptionLocator descriptionLocator) {
        int n2 = descriptionLocator.getPrefix().length();
        int n3 = 0;
        while ((n3 = stringBuilder.indexOf(descriptionLocator.getPrefix(), n3)) >= 0) {
            int n4;
            int n5 = n3 + n2;
            for (n4 = 0; n4 < descriptionLocator.getParameterCount() - 1; ++n4) {
                if (n5 <= 0) continue;
                n5 = stringBuilder.indexOf("/", n5) + 1;
            }
            int n6 = n4 = n5 > 0 ? stringBuilder.indexOf("/", n5) : -1;
            if (n4 >= 0) {
                String string;
                StringBuilder stringBuilder2 = new StringBuilder();
                if (descriptionLocator == DescriptionLocator.REFERENCE) {
                    stringBuilder2.append('[');
                }
                stringBuilder2.append("<a href=\"");
                stringBuilder2.append(stringBuilder.substring(n3, n4 + 1));
                stringBuilder2.append("\">");
                if (n5 == n4 && descriptionLocator == DescriptionLocator.GLOSSARY) {
                    int n7 = stringBuilder.indexOf("/", n3 + n2);
                    string = stringBuilder.substring(n3 + n2, n7);
                } else {
                    string = stringBuilder.substring(n5, n4);
                }
                stringBuilder2.append(string);
                stringBuilder2.append("</a>");
                if (descriptionLocator == DescriptionLocator.REFERENCE) {
                    stringBuilder2.append(']');
                }
                stringBuilder.replace(n3, n4 + 1, stringBuilder2.toString());
                n3 += stringBuilder2.length();
                continue;
            }
            n3 += n2;
        }
    }
}

