/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.metrics;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.metrics.FilterAttributeProcessor;
import com.sdmetrics.metrics.MetricEntry;
import com.sdmetrics.metrics.MetricsEngine;
import com.sdmetrics.metrics.ProcedureAttributes;
import com.sdmetrics.metrics.SDMetricsException;
import com.sdmetrics.metrics.Variables;
import com.sdmetrics.model.MetaModel;
import com.sdmetrics.model.MetaModelElement;
import com.sdmetrics.model.Model;
import com.sdmetrics.model.ModelElement;
import java.util.Collection;

public class AbstractProcedure {
    private String name;
    private MetricsEngine metricsEngine;

    protected MetricsEngine getMetricsEngine() {
        return this.metricsEngine;
    }

    protected Collection<ModelElement> getRelationOrSet(ModelElement modelElement, ProcedureAttributes procedureAttributes, Variables variables) throws SDMetricsException {
        String string = procedureAttributes.getStringValue("relation");
        if (string != null) {
            return modelElement.getRelations(string);
        }
        ExpressionNode expressionNode = procedureAttributes.getExpression("relset");
        if (expressionNode == null) {
            throw new SDMetricsException(modelElement, null, "Neither 'relation' nor 'relset' attribute specified.");
        }
        return this.metricsEngine.evalSetExpression(modelElement, expressionNode, variables);
    }

    protected FilterAttributeProcessor getFilterAttributeProcessor(ProcedureAttributes procedureAttributes) throws SDMetricsException {
        return new FilterAttributeProcessor(this.getMetricsEngine(), procedureAttributes);
    }

    protected Model getModel() {
        return this.metricsEngine.getModel();
    }

    protected MetaModel getMetaModel() {
        return this.metricsEngine.getMetaModel();
    }

    protected Object evalExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        return this.metricsEngine.evalExpression(modelElement, expressionNode, variables);
    }

    protected boolean evalBooleanExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        return this.metricsEngine.evalBooleanExpression(modelElement, expressionNode, variables);
    }

    protected Collection<?> evalSetExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        return this.metricsEngine.evalSetExpression(modelElement, expressionNode, variables);
    }

    protected Collection<ModelElement> evalElementSetExpression(ModelElement modelElement, ExpressionNode expressionNode, Variables variables) throws SDMetricsException {
        return this.metricsEngine.evalSetExpression(modelElement, expressionNode, variables);
    }

    protected boolean isCompatible(ModelElement modelElement, MetricEntry metricEntry, ModelElement modelElement2) {
        MetaModelElement metaModelElement;
        MetaModelElement metaModelElement2 = modelElement.getType();
        if (metaModelElement2 == (metaModelElement = modelElement2.getType())) {
            return true;
        }
        if (metricEntry.isInheritable()) {
            return (metaModelElement.specializes(metaModelElement2) || metaModelElement2.specializes(metaModelElement)) && this.metricsEngine.getMetricStore().getMetric(metaModelElement, metricEntry.getName()) != null;
        }
        return false;
    }

    void setName(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    void setMetricsEngine(MetricsEngine metricsEngine) {
        this.metricsEngine = metricsEngine;
    }

    void clear() {
        this.metricsEngine = null;
    }
}

