/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.math;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class MappedCollectionsIterator<T>
implements Iterator<T> {
    private Iterator<? extends Collection<T>> outerIterator;
    private Iterator<T> innerIterator;
    private T nextObject;
    private boolean hasNextObject;

    public MappedCollectionsIterator(Map<?, ? extends Collection<T>> map) {
        this.outerIterator = map.values().iterator();
        this.innerIterator = null;
        this.hasNextObject = true;
        this.getReady();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        if (this.hasNextObject) {
            T t2 = this.nextObject;
            this.getReady();
            return t2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextObject;
    }

    private void getReady() {
        if (this.innerIterator == null) {
            this.nextInner();
            if (this.innerIterator == null) {
                return;
            }
        }
        if (this.innerIterator.hasNext()) {
            this.nextObject = this.innerIterator.next();
        } else {
            this.innerIterator = null;
            this.getReady();
        }
    }

    private void nextInner() {
        if (this.outerIterator.hasNext()) {
            Collection<T> collection = this.outerIterator.next();
            this.innerIterator = collection.iterator();
        } else {
            this.hasNextObject = false;
        }
    }
}

