/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.math;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class HashMultiSet<E>
extends AbstractCollection<E> {
    private static final Integer ONE = 1;
    private HashMap<E, Integer> backingMap;
    private int elementCount = 0;

    public HashMultiSet(int n2) {
        this.backingMap = new HashMap(n2);
    }

    public HashMultiSet(Collection<? extends E> collection) {
        this.backingMap = new HashMap(collection.size());
        this.addAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return new HashMultiSetIterator(false);
    }

    public Iterator<E> getFlatIterator() {
        return new HashMultiSetIterator(true);
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    public int flatSetSize() {
        return this.backingMap.size();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    public int getElementCount(Object object) {
        Integer n2 = this.backingMap.get(object);
        return n2 == null ? 0 : n2;
    }

    @Override
    public boolean add(E e2) {
        Integer n2 = this.backingMap.get(e2);
        if (n2 == null) {
            this.backingMap.put(e2, ONE);
        } else {
            this.backingMap.put(e2, n2 + 1);
        }
        ++this.elementCount;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        Integer n2 = this.backingMap.get(object);
        if (n2 == null) {
            return false;
        }
        if (ONE.equals(n2)) {
            this.backingMap.remove(object);
        } else {
            this.backingMap.put(object, n2 - 1);
        }
        --this.elementCount;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        HashMultiSet hashMultiSet = this.makeMultiSet(collection);
        boolean bl = false;
        Iterator<Map.Entry<E, Integer>> iterator = this.backingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<E, Integer> entry = iterator.next();
            Integer n2 = hashMultiSet.backingMap.get(entry.getKey());
            int n3 = entry.getValue();
            if (n2 == null) {
                this.elementCount -= n3;
                iterator.remove();
                bl = true;
                continue;
            }
            int n4 = n3 - n2;
            if (n4 <= 0) continue;
            entry.setValue(n3 - n4);
            this.elementCount -= n4;
            bl = true;
        }
        return bl;
    }

    private HashMultiSet makeMultiSet(Collection<?> collection) {
        if (collection instanceof HashMultiSet) {
            return (HashMultiSet)collection;
        }
        return new HashMultiSet(collection);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
        this.elementCount = 0;
    }

    public int removeAny(Object object) {
        Integer n2 = this.backingMap.remove(object);
        if (n2 != null) {
            this.elementCount -= n2.intValue();
            return n2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (collection.size() != this.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        HashMultiSet hashMultiSet = this.makeMultiSet(collection);
        if (hashMultiSet.flatSetSize() != this.flatSetSize()) {
            return false;
        }
        for (Map.Entry<E, Integer> entry : this.backingMap.entrySet()) {
            if (entry.getValue().equals(hashMultiSet.backingMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (Map.Entry<E, Integer> entry : this.backingMap.entrySet()) {
            int n3 = entry.getKey() == null ? 0 : entry.getKey().hashCode();
            n2 += n3 ^ entry.getValue();
        }
        return n2;
    }

    class HashMultiSetIterator
    implements Iterator<E> {
        private Iterator<Map.Entry<E, Integer>> backingIterator;
        private boolean hasNextElement;
        private E nextElement;
        private int elementCounter;
        private boolean isFlatIteration;

        HashMultiSetIterator(boolean bl) {
            this.backingIterator = HashMultiSet.this.backingMap.entrySet().iterator();
            this.elementCounter = 0;
            this.hasNextElement = true;
            this.isFlatIteration = bl;
            this.getReady();
        }

        @Override
        public boolean hasNext() {
            return this.hasNextElement;
        }

        @Override
        public E next() {
            if (this.hasNextElement) {
                Object e2 = this.nextElement;
                this.getReady();
                return e2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void getReady() {
            if (this.elementCounter > 0) {
                --this.elementCounter;
                return;
            }
            if (this.backingIterator.hasNext()) {
                Map.Entry entry = this.backingIterator.next();
                this.nextElement = entry.getKey();
                this.elementCounter = this.isFlatIteration ? 0 : entry.getValue() - 1;
                return;
            }
            this.hasNextElement = false;
        }
    }
}

