/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.math;

import com.sdmetrics.math.ExpressionNode;
import com.sdmetrics.math.NodeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class ExpressionParser {
    private static final ExpressionNode OPENINGPARENTHESIS = new ExpressionNode(null, "(");
    private static final ExpressionNode CLOSINGPARENTHESIS = new ExpressionNode(null, ")");
    private static final ExpressionNode EXPRESSIONLISTSEPARATOR = new ExpressionNode(null, ",");
    private static final ExpressionNode ENDNODE = new ExpressionNode(null, "");
    private String expression;
    private int currentPos;
    private ExpressionNode currentNode;
    private String errorMessage;
    private Set<String> functionNames;
    private Set<String> highPrecedenceRelationNames;
    private Set<String> lowPrecedenceRelationNames;

    public ExpressionParser() {
        this(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public ExpressionParser(Set<String> set, Set<String> set2, Set<String> set3) {
        this.functionNames = set;
        this.highPrecedenceRelationNames = set2;
        this.lowPrecedenceRelationNames = set3;
    }

    public ExpressionNode parseExpression(String string) {
        this.expression = string;
        this.currentPos = 0;
        this.errorMessage = "";
        ExpressionNode expressionNode = null;
        try {
            expressionNode = this.parseExpression();
            if (this.currentPos < this.expression.length() || this.currentNode != ENDNODE) {
                throw new ParserException("Unexpected token past end of expression: " + this.currentNode.getValue(), this.currentPos);
            }
        }
        catch (ParserException parserException) {
            this.errorMessage = parserException.getMessage();
            expressionNode = null;
        }
        return expressionNode;
    }

    public String getErrorInfo() {
        return this.errorMessage;
    }

    private ExpressionNode parseExpression() {
        return this.lowPrecedenceRelationExpression();
    }

    private ExpressionNode lowPrecedenceRelationExpression() {
        ExpressionNode expressionNode = this.orExpression();
        while (this.currentNode.isOperation() && this.isLowPrecedenceRelation(this.currentNode.getValue())) {
            String string = this.currentNode.getValue();
            expressionNode = this.handleRightHandSide(expressionNode, string, this.orExpression());
        }
        return expressionNode;
    }

    private boolean isFunction(String string) {
        return this.functionNames.contains(string);
    }

    private boolean isHighPrecedenceRelation(String string) {
        return this.highPrecedenceRelationNames.contains(string);
    }

    private boolean isLowPrecedenceRelation(String string) {
        return this.lowPrecedenceRelationNames.contains(string);
    }

    private boolean isCurrentNodeValue(String string) {
        return string.equals(this.currentNode.getValue());
    }

    private ExpressionNode handleRightHandSide(ExpressionNode expressionNode, String string, ExpressionNode expressionNode2) {
        if (expressionNode2 == null) {
            throw new ParserException("Missing right hand side for operator " + string, this.currentPos);
        }
        return new ExpressionNode(string, new ExpressionNode[]{expressionNode, expressionNode2});
    }

    private ExpressionNode orExpression() {
        ExpressionNode expressionNode = this.andExpression();
        while (this.currentNode.isOperation() && this.isCurrentNodeValue("|")) {
            expressionNode = this.handleRightHandSide(expressionNode, "|", this.andExpression());
        }
        return expressionNode;
    }

    private ExpressionNode andExpression() {
        ExpressionNode expressionNode = this.equalExpression();
        while (this.currentNode.isOperation() && this.isCurrentNodeValue("&")) {
            expressionNode = this.handleRightHandSide(expressionNode, "&", this.equalExpression());
        }
        return expressionNode;
    }

    private ExpressionNode equalExpression() {
        ExpressionNode expressionNode = this.relExpression();
        if (this.currentNode.isOperation() && (this.isCurrentNodeValue("=") || this.isCurrentNodeValue("!="))) {
            String string = this.currentNode.getValue();
            expressionNode = this.handleRightHandSide(expressionNode, string, this.relExpression());
        }
        return expressionNode;
    }

    private ExpressionNode relExpression() {
        ExpressionNode expressionNode = this.addExpression();
        if (this.currentNode.isOperation() && (this.isCurrentNodeValue("<") || this.isCurrentNodeValue(">") || this.isCurrentNodeValue("<=") || this.isCurrentNodeValue(">=") || this.isHighPrecedenceRelation(this.currentNode.getValue()))) {
            String string = this.currentNode.getValue();
            expressionNode = this.handleRightHandSide(expressionNode, string, this.addExpression());
        }
        return expressionNode;
    }

    private ExpressionNode addExpression() {
        ExpressionNode expressionNode = this.multExpression();
        while (this.currentNode.isOperation() && (this.isCurrentNodeValue("+") || this.isCurrentNodeValue("-"))) {
            String string = this.currentNode.getValue();
            expressionNode = this.handleRightHandSide(expressionNode, string, this.multExpression());
        }
        return expressionNode;
    }

    private ExpressionNode multExpression() {
        ExpressionNode expressionNode = this.powExpression();
        while (this.currentNode.isOperation() && (this.isCurrentNodeValue("/") || this.isCurrentNodeValue("*"))) {
            String string = this.currentNode.getValue();
            expressionNode = this.handleRightHandSide(expressionNode, string, this.powExpression());
        }
        return expressionNode;
    }

    private ExpressionNode powExpression() {
        ExpressionNode expressionNode = this.dotExpression();
        while (this.currentNode.isOperation() && (this.isCurrentNodeValue("^") || this.isCurrentNodeValue("->"))) {
            String string = this.currentNode.getValue();
            expressionNode = this.handleRightHandSide(expressionNode, string, this.dotExpression());
        }
        return expressionNode;
    }

    private ExpressionNode dotExpression() {
        ExpressionNode expressionNode = this.unaryExpression();
        while (this.currentNode.isOperation() && this.isCurrentNodeValue(".")) {
            expressionNode = this.handleRightHandSide(expressionNode, ".", this.unaryExpression());
        }
        return expressionNode;
    }

    private ExpressionNode unaryExpression() {
        this.nextToken();
        String string = this.currentNode.getValue();
        if (this.currentNode.isNumberConstant() || this.currentNode.isStringConstant() || this.currentNode.isIdentifier()) {
            ExpressionNode expressionNode = this.currentNode;
            this.nextToken();
            return expressionNode;
        }
        if (this.currentNode.isOperation() && this.isFunction(string)) {
            ExpressionNode expressionNode = this.currentNode;
            ArrayList<ExpressionNode> arrayList = new ArrayList<ExpressionNode>();
            String string2 = string;
            int n2 = this.currentPos;
            this.nextToken();
            if (this.currentNode != OPENINGPARENTHESIS) {
                throw new ParserException("Expected opening parenthesis following function call to '" + string2 + "'.", this.currentPos);
            }
            do {
                arrayList.add(this.parseExpression());
            } while (this.currentNode == EXPRESSIONLISTSEPARATOR);
            if (this.currentNode != CLOSINGPARENTHESIS) {
                throw new ParserException("Missing closing parenthesis following function call to '" + string2 + "' at position " + n2 + ".", this.currentPos);
            }
            expressionNode.setValue(NodeType.OPERATION, string2, arrayList.toArray(new ExpressionNode[arrayList.size()]));
            this.nextToken();
            return expressionNode;
        }
        if (this.currentNode.isOperation() && "-".equals(string) || "+".equals(string) || "!".equals(string)) {
            ExpressionNode expressionNode = this.currentNode;
            expressionNode.setValue(NodeType.OPERATION, string, new ExpressionNode[]{this.unaryExpression()});
            return expressionNode;
        }
        if (this.currentNode == OPENINGPARENTHESIS) {
            int n3 = this.currentPos;
            ExpressionNode expressionNode = this.parseExpression();
            if (this.currentNode == CLOSINGPARENTHESIS) {
                this.nextToken();
                return expressionNode;
            }
            throw new ParserException("Missing closing parenthesis opened at position " + n3 + ".", this.currentPos);
        }
        if (this.currentNode == ENDNODE) {
            throw new ParserException("Unexpected end of expression.", this.currentPos);
        }
        throw new ParserException("Unexpected token: " + string, this.currentPos);
    }

    private void nextToken() {
        while (this.currentPos < this.expression.length() && Character.isSpaceChar(this.expression.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (this.currentPos >= this.expression.length()) {
            this.currentNode = ENDNODE;
        } else if (this.expression.charAt(this.currentPos) == '+' || this.expression.charAt(this.currentPos) == '-' || this.expression.charAt(this.currentPos) == '*' || this.expression.charAt(this.currentPos) == '^' || this.expression.charAt(this.currentPos) == '/' || this.expression.charAt(this.currentPos) == '=' || this.expression.charAt(this.currentPos) == '|' || this.expression.charAt(this.currentPos) == '!' || this.expression.charAt(this.currentPos) == '<' || this.expression.charAt(this.currentPos) == '>' || this.expression.charAt(this.currentPos) == '.' || this.expression.charAt(this.currentPos) == '&') {
            this.handleSymbolicOperatorToken();
        } else if (this.expression.charAt(this.currentPos) == '(') {
            ++this.currentPos;
            this.currentNode = OPENINGPARENTHESIS;
        } else if (this.expression.charAt(this.currentPos) == ')') {
            ++this.currentPos;
            this.currentNode = CLOSINGPARENTHESIS;
        } else if (this.expression.charAt(this.currentPos) == ',') {
            ++this.currentPos;
            this.currentNode = EXPRESSIONLISTSEPARATOR;
        } else if (this.expression.charAt(this.currentPos) == '\'') {
            this.currentNode = new ExpressionNode(NodeType.STRING, this.getStringConstant());
        } else if (Character.isDigit(this.expression.charAt(this.currentPos))) {
            this.currentNode = new ExpressionNode(NodeType.NUMBER, this.getNumberConstant());
        } else {
            this.handleIdentifier();
        }
    }

    private void handleSymbolicOperatorToken() {
        String string = String.valueOf(this.expression.charAt(this.currentPos));
        ++this.currentPos;
        if ("&".equals(string) && this.currentPos + 3 < this.expression.length()) {
            if ("amp;".equals(this.expression.substring(this.currentPos, this.currentPos + 4))) {
                this.currentPos += 4;
            } else if (this.expression.substring(this.currentPos, this.currentPos + 3).equals("lt;")) {
                this.currentPos += 3;
                string = "<";
            }
        }
        if (this.currentPos < this.expression.length() && this.expression.charAt(this.currentPos) == '=') {
            if ("<".equals(string) || ">".equals(string) || "!".equals(string)) {
                string = string + this.expression.charAt(this.currentPos);
                ++this.currentPos;
            }
        } else if (this.currentPos < this.expression.length() && this.expression.charAt(this.currentPos) == '>' && "-".equals(string)) {
            string = string + this.expression.charAt(this.currentPos);
            ++this.currentPos;
        }
        this.currentNode = new ExpressionNode(NodeType.OPERATION, string);
    }

    private void handleIdentifier() {
        String string;
        String string2 = this.getIdentifier();
        NodeType nodeType = NodeType.OPERATION;
        if (string2.startsWith("fct_") && this.isFunction(string = string2.substring(4))) {
            string2 = string;
        }
        if (this.isFunction(string2) || this.isHighPrecedenceRelation(string2) || this.isLowPrecedenceRelation(string2)) {
            nodeType = NodeType.OPERATION;
        } else if ("and".equals(string2)) {
            string2 = "&";
        } else if ("or".equals(string2)) {
            string2 = "|";
        } else if ("not".equals(string2)) {
            string2 = "!";
        } else if ("lt".equals(string2)) {
            string2 = "<";
        } else if ("gt".equals(string2)) {
            string2 = ">";
        } else if ("le".equals(string2)) {
            string2 = "<=";
        } else if ("ge".equals(string2)) {
            string2 = ">=";
        } else if ("in".equals(string2)) {
            string2 = "->";
        } else {
            nodeType = NodeType.IDENTIFIER;
        }
        this.currentNode = new ExpressionNode(nodeType, string2);
    }

    private String getNumberConstant() {
        int n2;
        int n3 = this.currentPos;
        while (this.currentPos < this.expression.length() && Character.isDigit(this.expression.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (this.currentPos < this.expression.length() && this.expression.charAt(this.currentPos) == '.') {
            ++this.currentPos;
            n2 = this.currentPos;
            while (this.currentPos < this.expression.length() && Character.isDigit(this.expression.charAt(this.currentPos))) {
                ++this.currentPos;
            }
            if (n2 == this.currentPos) {
                throw new ParserException("Missing fraction part of number constant.", this.currentPos);
            }
        }
        if (this.currentPos < this.expression.length() && (this.expression.charAt(this.currentPos) == 'e' || this.expression.charAt(this.currentPos) == 'E')) {
            ++this.currentPos;
            if (this.currentPos < this.expression.length() && (this.expression.charAt(this.currentPos) == '+' || this.expression.charAt(this.currentPos) == '-')) {
                ++this.currentPos;
            }
            n2 = this.currentPos;
            while (this.currentPos < this.expression.length() && Character.isDigit(this.expression.charAt(this.currentPos))) {
                ++this.currentPos;
            }
            if (n2 == this.currentPos) {
                throw new ParserException("Missing exponent of scientific notation number constant.", this.currentPos);
            }
        }
        return this.expression.substring(n3, this.currentPos);
    }

    private String getIdentifier() {
        int n2 = this.currentPos;
        while (this.currentPos < this.expression.length() && ExpressionParser.isIdentifierCharacter(this.expression.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (n2 == this.currentPos) {
            throw new ParserException("Unexpected character: " + this.expression.charAt(this.currentPos), n2 + 1);
        }
        return this.expression.substring(n2, this.currentPos);
    }

    public static boolean isIdentifierCharacter(char c2) {
        return Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_';
    }

    private String getStringConstant() {
        ++this.currentPos;
        int n2 = this.currentPos;
        while (this.currentPos < this.expression.length() && this.expression.charAt(this.currentPos) != '\'') {
            ++this.currentPos;
        }
        if (this.currentPos == this.expression.length()) {
            throw new ParserException("Missing closing apostrophe of string constant starting at position " + n2 + ".", this.currentPos);
        }
        ++this.currentPos;
        return this.expression.substring(n2, this.currentPos - 1);
    }

    static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 4537409434255097180L;

        ParserException(String string, int n2) {
            super("Parse error at position " + n2 + ": " + string);
        }
    }
}

