/*
 * Decompiled with CFR 0.152.
 */
package com.sdmetrics.math;

import com.sdmetrics.math.NodeType;

public class ExpressionNode {
    private NodeType type;
    private String value;
    ExpressionNode[] operands;

    public ExpressionNode(String string) {
        this(NodeType.IDENTIFIER, string);
    }

    ExpressionNode(NodeType nodeType, String string) {
        this.setValue(nodeType, string, null);
    }

    ExpressionNode(String string, ExpressionNode[] expressionNodeArray) {
        this.setValue(NodeType.OPERATION, string, expressionNodeArray);
    }

    public String getValue() {
        return this.value;
    }

    void setValue(NodeType nodeType, String string, ExpressionNode[] expressionNodeArray) {
        this.type = nodeType;
        this.value = string;
        this.operands = expressionNodeArray;
    }

    public int getOperandCount() {
        return this.operands == null ? 0 : this.operands.length;
    }

    public ExpressionNode getOperand(int n2) {
        if (n2 >= this.getOperandCount()) {
            throw new IllegalArgumentException("No argument at index " + n2 + " for operator '" + this.getValue() + "'.");
        }
        return this.operands[n2];
    }

    public ExpressionNode getLeftNode() {
        return this.operands == null ? null : this.operands[0];
    }

    public ExpressionNode getRightNode() {
        return this.operands == null || this.operands.length < 2 ? null : this.operands[1];
    }

    public boolean isOperation() {
        return this.type == NodeType.OPERATION;
    }

    public boolean isNumberConstant() {
        return this.type == NodeType.NUMBER;
    }

    public boolean isStringConstant() {
        return this.type == NodeType.STRING;
    }

    public boolean isIdentifier() {
        return this.type == NodeType.IDENTIFIER;
    }
}

